/*
 * Decompiled with CFR 0.152.
 */
package one.tomorrow.transactionaloutbox.model;

import com.vladmihalcea.hibernate.type.json.JsonBinaryType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import lombok.Generated;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;

@Entity
@Table(name="outbox_kafka")
public class OutboxRecord {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @CreationTimestamp
    private Timestamp created;
    @Column(name="processed")
    private Instant processed;
    @Column(name="topic", nullable=false)
    private String topic;
    @Column(name="key")
    private String key;
    @Column(name="value", nullable=false)
    private byte[] value;
    @Type(value=JsonBinaryType.class)
    @Column(name="headers", columnDefinition="jsonb")
    private Map<String, String> headers;

    @Generated
    public static OutboxRecordBuilder builder() {
        return new OutboxRecordBuilder();
    }

    @Generated
    public OutboxRecord(Long id, Timestamp created, Instant processed, String topic, String key, byte[] value, Map<String, String> headers) {
        this.id = id;
        this.created = created;
        this.processed = processed;
        this.topic = topic;
        this.key = key;
        this.value = value;
        this.headers = headers;
    }

    @Generated
    public OutboxRecord() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Timestamp getCreated() {
        return this.created;
    }

    @Generated
    public Instant getProcessed() {
        return this.processed;
    }

    @Generated
    public String getTopic() {
        return this.topic;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public byte[] getValue() {
        return this.value;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCreated(Timestamp created) {
        this.created = created;
    }

    @Generated
    public void setProcessed(Instant processed) {
        this.processed = processed;
    }

    @Generated
    public void setTopic(String topic) {
        this.topic = topic;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setValue(byte[] value) {
        this.value = value;
    }

    @Generated
    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    @Generated
    public String toString() {
        return "OutboxRecord(id=" + this.getId() + ", created=" + this.getCreated() + ", processed=" + this.getProcessed() + ", topic=" + this.getTopic() + ", key=" + this.getKey() + ", headers=" + this.getHeaders() + ")";
    }

    @Generated
    public static class OutboxRecordBuilder {
        @Generated
        private Long id;
        @Generated
        private Timestamp created;
        @Generated
        private Instant processed;
        @Generated
        private String topic;
        @Generated
        private String key;
        @Generated
        private byte[] value;
        @Generated
        private Map<String, String> headers;

        @Generated
        OutboxRecordBuilder() {
        }

        @Generated
        public OutboxRecordBuilder id(Long id) {
            this.id = id;
            return this;
        }

        @Generated
        public OutboxRecordBuilder created(Timestamp created) {
            this.created = created;
            return this;
        }

        @Generated
        public OutboxRecordBuilder processed(Instant processed) {
            this.processed = processed;
            return this;
        }

        @Generated
        public OutboxRecordBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        @Generated
        public OutboxRecordBuilder key(String key) {
            this.key = key;
            return this;
        }

        @Generated
        public OutboxRecordBuilder value(byte[] value) {
            this.value = value;
            return this;
        }

        @Generated
        public OutboxRecordBuilder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        @Generated
        public OutboxRecord build() {
            return new OutboxRecord(this.id, this.created, this.processed, this.topic, this.key, this.value, this.headers);
        }

        @Generated
        public String toString() {
            return "OutboxRecord.OutboxRecordBuilder(id=" + this.id + ", created=" + this.created + ", processed=" + this.processed + ", topic=" + this.topic + ", key=" + this.key + ", value=" + Arrays.toString(this.value) + ", headers=" + this.headers + ")";
        }
    }
}

