/*
 * Decompiled with CFR 0.152.
 */
package one.tomorrow.transactionaloutbox.repository;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import one.tomorrow.transactionaloutbox.model.OutboxRecord;
import org.postgresql.util.PGobject;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.springframework.stereotype.Repository;

@Repository
public class OutboxRepository {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final RowMapper<OutboxRecord> ROW_MAPPER = (rs, rowNum) -> {
        Timestamp processed = rs.getTimestamp("processed");
        return new OutboxRecord(rs.getLong("id"), rs.getTimestamp("created"), processed == null ? null : processed.toInstant(), rs.getString("topic"), rs.getString("key"), rs.getBytes("value"), OutboxRepository.fromJson(rs.getString("headers")));
    };
    private final JdbcTemplate jdbcTemplate;
    private final SimpleJdbcInsert jdbcInsert;

    public OutboxRepository(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.jdbcInsert = new SimpleJdbcInsert(jdbcTemplate).withTableName("outbox_kafka").usingGeneratedKeyColumns(new String[]{"id"});
    }

    public void persist(OutboxRecord record) {
        record.setCreated(new Timestamp(System.currentTimeMillis()));
        Long id = (Long)this.jdbcInsert.executeAndReturnKey(OutboxRepository.argsFor(record));
        record.setId(id);
    }

    private static Map<String, Object> argsFor(OutboxRecord record) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("created", record.getCreated());
        if (record.getProcessed() != null) {
            args.put("processed", Timestamp.from(record.getProcessed()));
        }
        args.put("topic", record.getTopic());
        if (record.getKey() != null) {
            args.put("key", record.getKey());
        }
        args.put("value", record.getValue());
        args.put("headers", OutboxRepository.toJson(record.getHeaders()));
        return args;
    }

    public void updateProcessed(Long id, Instant processed) {
        this.jdbcTemplate.update("update outbox_kafka set processed = ? where id = ?", new Object[]{Timestamp.from(processed), id});
    }

    public List<OutboxRecord> getUnprocessedRecords(int limit) {
        return this.jdbcTemplate.query("select * from outbox_kafka where processed is null order by id asc limit " + limit, ROW_MAPPER);
    }

    private static Map<String, String> fromJson(String data) {
        try {
            return data == null ? null : (Map)OBJECT_MAPPER.readValue(data, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static PGobject toJson(Map<String, String> headers) {
        if (headers == null) {
            return null;
        }
        try {
            PGobject holder = new PGobject();
            holder.setType("jsonb");
            holder.setValue(OBJECT_MAPPER.writeValueAsString(headers));
            return holder;
        }
        catch (JsonProcessingException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int deleteOutboxRecordByProcessedNotNullAndProcessedIsBefore(Instant deleteOlderThan) {
        return this.jdbcTemplate.update("DELETE FROM outbox_kafka WHERE processed IS NOT NULL AND processed < ?", new Object[]{Timestamp.from(deleteOlderThan)});
    }
}

