/*
 * Decompiled with CFR 0.152.
 */
package one.tomorrow.transactionaloutbox.service;

import java.time.Duration;
import lombok.Generated;
import one.tomorrow.transactionaloutbox.repository.OutboxLockRepository;
import org.springframework.transaction.annotation.Transactional;

public class OutboxLockService {
    private final OutboxLockRepository repository;
    private final Duration lockTimeout;

    public boolean acquireOrRefreshLock(String ownerId) {
        return this.repository.acquireOrRefreshLock(ownerId, this.lockTimeout);
    }

    public void releaseLock(String ownerId) {
        this.repository.releaseLock(ownerId);
    }

    @Transactional
    public boolean runWithLock(String ownerId, Runnable action) {
        boolean outboxLockIsPreventedFromLockStealing = this.repository.preventLockStealing(ownerId);
        if (outboxLockIsPreventedFromLockStealing) {
            action.run();
        }
        return outboxLockIsPreventedFromLockStealing;
    }

    @Generated
    public OutboxLockService(OutboxLockRepository repository, Duration lockTimeout) {
        this.repository = repository;
        this.lockTimeout = lockTimeout;
    }

    @Generated
    public Duration getLockTimeout() {
        return this.lockTimeout;
    }
}

