/*
 * Decompiled with CFR 0.152.
 */
package one.tomorrow.transactionaloutbox.service;

import java.util.HashMap;
import java.util.Map;
import one.tomorrow.transactionaloutbox.service.OutboxProcessor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKafkaProducerFactory
implements OutboxProcessor.KafkaProducerFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultKafkaProducerFactory.class);
    private final HashMap<String, Object> producerProps;

    public DefaultKafkaProducerFactory(Map<String, Object> producerProps) {
        HashMap<String, Object> props = new HashMap<String, Object>(producerProps);
        if (Boolean.FALSE.equals(props.get("enable.idempotence"))) {
            logger.warn("enable.idempotence is set to 'false' - this might lead to out-of-order messages.");
        }
        DefaultKafkaProducerFactory.setIfNotSet(props, "enable.idempotence", true);
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", ByteArraySerializer.class);
        this.producerProps = props;
    }

    private static void setIfNotSet(Map<String, Object> props, String prop, Object value) {
        if (!props.containsKey(prop)) {
            props.put(prop, value);
        }
    }

    @Override
    public KafkaProducer<String, byte[]> createKafkaProducer() {
        return new KafkaProducer(this.producerProps);
    }

    public String toString() {
        return "DefaultKafkaProducerFactory{producerProps=" + String.valueOf(DefaultKafkaProducerFactory.loggableProducerProps(this.producerProps)) + "}";
    }

    static Map<String, Object> loggableProducerProps(Map<String, Object> producerProps) {
        HashMap<String, Object> maskedProducerProps = new HashMap<String, Object>(producerProps);
        maskedProducerProps.replaceAll((key, value) -> key.equalsIgnoreCase("sasl.jaas.config") ? "[hidden]" : value);
        return maskedProducerProps;
    }
}

