/*
 * Decompiled with CFR 0.152.
 */
package one.tomorrow.transactionaloutbox.tracing;

import io.micrometer.tracing.Span;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.propagation.Propagator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import one.tomorrow.transactionaloutbox.commons.spring.ConditionalOnClass;
import one.tomorrow.transactionaloutbox.model.OutboxRecord;
import one.tomorrow.transactionaloutbox.tracing.TracingService;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@ConditionalOnClass(value=Tracer.class)
@Service
@Primary
public class MicrometerTracingService
implements TracingService {
    static final String TO_PREFIX = "To_";
    private final Tracer tracer;
    private final Propagator propagator;

    @Override
    public Map<String, String> tracingHeadersForOutboxRecord() {
        TraceContext context = this.tracer.currentTraceContext().context();
        if (context == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        this.propagator.inject(context, result, (map, k, v) -> map.put("_internal_:" + k, v));
        return result;
    }

    @Override
    public TracingService.TraceOutboxRecordProcessingResult traceOutboxRecordProcessing(OutboxRecord outboxRecord) {
        Set<Map.Entry<String, String>> headerEntries = outboxRecord.getHeaders().entrySet();
        boolean containsTraceInfo = headerEntries.stream().anyMatch(e -> ((String)e.getKey()).startsWith("_internal_:"));
        if (!containsTraceInfo) {
            return new TracingService.HeadersOnlyTraceOutboxRecordProcessingResult(outboxRecord.getHeaders());
        }
        Span outboxSpan = this.propagator.extract(outboxRecord.getHeaders(), (map, k) -> (String)map.get("_internal_:" + k)).name("transactional-outbox").startTimestamp(outboxRecord.getCreated().getTime(), TimeUnit.MILLISECONDS).start();
        outboxSpan.end();
        Map<String, String> newHeaders = headerEntries.stream().filter(entry -> !((String)entry.getKey()).startsWith("_internal_:")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        final Span processingSpan = this.tracer.spanBuilder().setParent(outboxSpan.context()).name(TO_PREFIX + outboxRecord.getTopic()).kind(Span.Kind.PRODUCER).start();
        this.propagator.inject(processingSpan.context(), newHeaders, Map::put);
        return new TracingService.TraceOutboxRecordProcessingResult(newHeaders){

            @Override
            public void publishCompleted() {
                processingSpan.end();
            }

            @Override
            public void publishFailed(Throwable t) {
                processingSpan.error(t);
            }
        };
    }

    @Generated
    public MicrometerTracingService(Tracer tracer, Propagator propagator) {
        this.tracer = tracer;
        this.propagator = propagator;
    }
}

