/*
 * Decompiled with CFR 0.152.
 */
package one.tomorrow.transactionaloutbox.service;

import java.util.Map;
import lombok.Generated;
import one.tomorrow.transactionaloutbox.commons.Maps;
import one.tomorrow.transactionaloutbox.model.OutboxRecord;
import one.tomorrow.transactionaloutbox.repository.OutboxRepository;
import one.tomorrow.transactionaloutbox.tracing.TracingService;
import org.springframework.stereotype.Service;

@Service
public class OutboxService {
    private OutboxRepository repository;
    private TracingService tracingService;

    public OutboxRecord saveForPublishing(String topic, String key, byte[] value) {
        return this.saveForPublishing(topic, key, value, null);
    }

    public OutboxRecord saveForPublishing(String topic, String key, byte[] value, Map<String, String> headerMap) {
        Map<String, String> tracingHeaders = this.tracingService.tracingHeadersForOutboxRecord();
        Map headers = Maps.merge(headerMap, tracingHeaders);
        OutboxRecord outboxRecord = OutboxRecord.builder().topic(topic).key(key).value(value).headers(headers).build();
        this.repository.persist(outboxRecord);
        return outboxRecord;
    }

    @Generated
    public OutboxService(OutboxRepository repository, TracingService tracingService) {
        this.repository = repository;
        this.tracingService = tracingService;
    }
}

