/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.irs;

import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.EntityScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import java.util.concurrent.TimeUnit;
import one.tranic.irs.platform.Platform;
import one.tranic.irs.task.FoliaScheduledTask;
import one.tranic.irs.task.SpigotScheduledTask;
import one.tranic.irs.task.TaskImpl;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.jetbrains.annotations.NotNull;

public class PluginSchedulerBuilder {
    private final Plugin plugin;
    private boolean folia = Platform.isMultithreading();
    private boolean sync;
    private long delayTicks;
    private long period;
    private Runnable task;
    private Location location;
    private Entity entity;

    public PluginSchedulerBuilder(Plugin plugin) {
        this.plugin = plugin;
    }

    public static PluginSchedulerBuilder builder(Plugin plugin) {
        return new PluginSchedulerBuilder(plugin);
    }

    public void cancelTasks() {
        if (this.folia) {
            Bukkit.getGlobalRegionScheduler().cancelTasks(this.plugin);
            Bukkit.getAsyncScheduler().cancelTasks(this.plugin);
        } else {
            Bukkit.getScheduler().cancelTasks(this.plugin);
        }
    }

    public PluginSchedulerBuilder sync() {
        if (!this.sync) {
            this.sync = true;
        }
        return this;
    }

    public PluginSchedulerBuilder sync(@NotNull Location location) {
        if (this.location == null) {
            this.sync = true;
            this.location = location;
        }
        return this;
    }

    public PluginSchedulerBuilder sync(@NotNull Entity entity) {
        if (this.entity == null) {
            this.sync = true;
            this.entity = entity;
        }
        return this;
    }

    public PluginSchedulerBuilder async() {
        if (this.sync && !this.folia && this.location == null && this.entity == null) {
            this.sync = false;
        }
        return this;
    }

    public PluginSchedulerBuilder task(@NotNull Runnable runnable) {
        if (this.task == null) {
            this.task = runnable;
        }
        return this;
    }

    public PluginSchedulerBuilder delayTicks(long delayTicks) {
        this.delayTicks = this.folia && delayTicks < 1L ? 1L : delayTicks;
        return this;
    }

    public PluginSchedulerBuilder period(long period) {
        this.period = this.folia && period < 1L ? 1L : period;
        return this;
    }

    public TaskImpl<Plugin> run() {
        if (this.task == null) {
            throw new UnsupportedOperationException("It seems that the task has not been set.");
        }
        if (this.folia) {
            return this.runFoliaTask();
        }
        return this.runBukkitTask();
    }

    private TaskImpl<Plugin> runFoliaTask() {
        if (this.sync) {
            if (this.entity != null) {
                return this.newFoliaEntityTask();
            }
            if (this.location != null) {
                return this.newFoliaRegionTask();
            }
            return this.newFoliaGlobalRegionTask();
        }
        return this.newFoliaAsyncTask();
    }

    private TaskImpl<Plugin> runBukkitTask() {
        if (this.sync) {
            return this.newBukkitSyncTask();
        }
        return this.newBukkitAsyncTask();
    }

    private TaskImpl<Plugin> newFoliaEntityTask() {
        @NotNull EntityScheduler scheduler = this.entity.getScheduler();
        if (this.delayTicks != 0L) {
            if (this.period != 0L) {
                return new FoliaScheduledTask(scheduler.runAtFixedRate(this.plugin, e -> this.task.run(), null, this.delayTicks, this.period));
            }
            return new FoliaScheduledTask(scheduler.runDelayed(this.plugin, e -> this.task.run(), null, this.delayTicks));
        }
        return new FoliaScheduledTask(scheduler.run(this.plugin, e -> this.task.run(), null));
    }

    private TaskImpl<Plugin> newFoliaRegionTask() {
        @NotNull RegionScheduler scheduler = Bukkit.getRegionScheduler();
        if (this.delayTicks != 0L) {
            if (this.period != 0L) {
                return new FoliaScheduledTask(scheduler.runAtFixedRate(this.plugin, this.location, e -> this.task.run(), this.delayTicks, this.period));
            }
            return new FoliaScheduledTask(scheduler.runDelayed(this.plugin, this.location, e -> this.task.run(), this.delayTicks));
        }
        return new FoliaScheduledTask(scheduler.run(this.plugin, this.location, e -> this.task.run()));
    }

    private TaskImpl<Plugin> newFoliaGlobalRegionTask() {
        @NotNull GlobalRegionScheduler scheduler = Bukkit.getGlobalRegionScheduler();
        if (this.delayTicks != 0L) {
            if (this.period != 0L) {
                return new FoliaScheduledTask(scheduler.runAtFixedRate(this.plugin, e -> this.task.run(), this.delayTicks, this.period));
            }
            return new FoliaScheduledTask(scheduler.runDelayed(this.plugin, e -> this.task.run(), this.delayTicks));
        }
        return new FoliaScheduledTask(scheduler.run(this.plugin, e -> this.task.run()));
    }

    private TaskImpl<Plugin> newFoliaAsyncTask() {
        @NotNull AsyncScheduler scheduler = Bukkit.getAsyncScheduler();
        if (this.delayTicks != 0L) {
            if (this.period != 0L) {
                return new FoliaScheduledTask(scheduler.runAtFixedRate(this.plugin, e -> this.task.run(), this.delayTicks * 50L, this.period * 50L, TimeUnit.MILLISECONDS));
            }
            return new FoliaScheduledTask(scheduler.runDelayed(this.plugin, e -> this.task.run(), this.delayTicks * 50L, TimeUnit.MILLISECONDS));
        }
        return new FoliaScheduledTask(scheduler.runNow(this.plugin, e -> this.task.run()));
    }

    private TaskImpl<Plugin> newBukkitSyncTask() {
        @NotNull BukkitScheduler scheduler = Bukkit.getScheduler();
        if (this.delayTicks != 0L) {
            if (this.period != 0L) {
                return new SpigotScheduledTask(scheduler.runTaskTimer(this.plugin, this.task, this.delayTicks, this.period));
            }
            return new SpigotScheduledTask(scheduler.runTaskLater(this.plugin, this.task, this.delayTicks));
        }
        return new SpigotScheduledTask(scheduler.runTask(this.plugin, this.task));
    }

    private TaskImpl<Plugin> newBukkitAsyncTask() {
        @NotNull BukkitScheduler scheduler = Bukkit.getScheduler();
        if (this.delayTicks != 0L) {
            if (this.period != 0L) {
                return new SpigotScheduledTask(scheduler.runTaskTimerAsynchronously(this.plugin, this.task, this.delayTicks, this.period));
            }
            return new SpigotScheduledTask(scheduler.runTaskLaterAsynchronously(this.plugin, this.task, this.delayTicks));
        }
        return new SpigotScheduledTask(scheduler.runTaskAsynchronously(this.plugin, this.task));
    }
}

