/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.irs;

import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.EntityScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import one.tranic.irs.platform.Platform;
import one.tranic.irs.task.FoliaScheduledTask;
import one.tranic.irs.task.SpigotScheduledTask;
import one.tranic.irs.task.TaskImpl;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginSchedulerBuilder {
    private final Plugin plugin;
    private boolean folia = Platform.isMultithreading();
    private boolean sync;
    private long delayTicks;
    private long period;
    private Runnable task;
    private Consumer<? super TaskImpl<Plugin>> taskConsumer;
    private Location location;
    private Entity entity;

    public PluginSchedulerBuilder(Plugin plugin) {
        this.plugin = plugin;
    }

    public static PluginSchedulerBuilder builder(Plugin plugin) {
        return new PluginSchedulerBuilder(plugin);
    }

    public void cancelTasks() {
        if (this.folia) {
            Bukkit.getGlobalRegionScheduler().cancelTasks(this.plugin);
            Bukkit.getAsyncScheduler().cancelTasks(this.plugin);
        } else {
            Bukkit.getScheduler().cancelTasks(this.plugin);
        }
    }

    public PluginSchedulerBuilder sync() {
        if (!this.sync) {
            this.sync = true;
        }
        return this;
    }

    public PluginSchedulerBuilder sync(@NotNull Location location) {
        if (this.location == null) {
            this.sync = true;
            this.location = location;
        }
        return this;
    }

    public PluginSchedulerBuilder sync(@NotNull Entity entity) {
        if (this.entity == null) {
            this.sync = true;
            this.entity = entity;
        }
        return this;
    }

    public PluginSchedulerBuilder async() {
        if (this.sync && !this.folia && this.location == null && this.entity == null) {
            this.sync = false;
        }
        return this;
    }

    public PluginSchedulerBuilder task(@NotNull Runnable runnable) {
        this.task = runnable;
        this.taskConsumer = null;
        return this;
    }

    public PluginSchedulerBuilder task(@NotNull Consumer<? super TaskImpl<Plugin>> task) {
        this.taskConsumer = task;
        this.task = null;
        return this;
    }

    public PluginSchedulerBuilder delayTicks(long delayTicks) {
        this.delayTicks = this.folia && delayTicks < 1L ? 1L : delayTicks;
        return this;
    }

    public PluginSchedulerBuilder period(long period) {
        this.period = this.folia && period < 1L ? 1L : period;
        return this;
    }

    @Nullable
    public TaskImpl<Plugin> run() {
        if (this.task == null && this.taskConsumer == null) {
            throw new UnsupportedOperationException("It seems that the task has not been set.");
        }
        return this.folia ? new FoliaScheduledTask(this.runFoliaTask()) : this.runBukkitTask();
    }

    private void accept(ScheduledTask scheduledTask) {
        if (this.taskConsumer != null) {
            this.taskConsumer.accept(new FoliaScheduledTask(scheduledTask));
        } else {
            this.task.run();
        }
    }

    private void accept(BukkitTask bukkitTask) {
        this.taskConsumer.accept(new SpigotScheduledTask(bukkitTask));
    }

    @Nullable
    private ScheduledTask runFoliaTask() {
        if (this.sync) {
            if (this.entity != null) {
                return this.newFoliaEntityTask();
            }
            if (this.location != null) {
                return this.newFoliaRegionTask();
            }
            return this.newFoliaGlobalRegionTask();
        }
        return this.newFoliaAsyncTask();
    }

    @Nullable
    private TaskImpl<Plugin> runBukkitTask() {
        return this.sync ? this.newBukkitSyncTask() : this.newBukkitAsyncTask();
    }

    @Nullable
    private ScheduledTask newFoliaEntityTask() {
        @NotNull EntityScheduler scheduler = this.entity.getScheduler();
        if (this.delayTicks != 0L) {
            return this.period != 0L ? scheduler.runAtFixedRate(this.plugin, this::accept, null, this.delayTicks, this.period) : scheduler.runDelayed(this.plugin, this::accept, null, this.delayTicks);
        }
        return scheduler.run(this.plugin, this::accept, null);
    }

    @NotNull
    private ScheduledTask newFoliaRegionTask() {
        @NotNull RegionScheduler scheduler = Bukkit.getRegionScheduler();
        if (this.delayTicks != 0L) {
            return this.period != 0L ? scheduler.runAtFixedRate(this.plugin, this.location, this::accept, this.delayTicks, this.period) : scheduler.runDelayed(this.plugin, this.location, this::accept, this.delayTicks);
        }
        return scheduler.run(this.plugin, this.location, this::accept);
    }

    @NotNull
    private ScheduledTask newFoliaGlobalRegionTask() {
        @NotNull GlobalRegionScheduler scheduler = Bukkit.getGlobalRegionScheduler();
        if (this.delayTicks != 0L) {
            return this.period != 0L ? scheduler.runAtFixedRate(this.plugin, this::accept, this.delayTicks, this.period) : scheduler.runDelayed(this.plugin, this::accept, this.delayTicks);
        }
        return scheduler.run(this.plugin, this::accept);
    }

    @NotNull
    private ScheduledTask newFoliaAsyncTask() {
        @NotNull AsyncScheduler scheduler = Bukkit.getAsyncScheduler();
        if (this.delayTicks != 0L) {
            return this.period != 0L ? scheduler.runAtFixedRate(this.plugin, this::accept, this.delayTicks * 50L, this.period * 50L, TimeUnit.MILLISECONDS) : scheduler.runDelayed(this.plugin, this::accept, this.delayTicks * 50L, TimeUnit.MILLISECONDS);
        }
        return scheduler.runNow(this.plugin, this::accept);
    }

    @Nullable
    private TaskImpl<Plugin> newBukkitSyncTask() {
        @NotNull BukkitScheduler scheduler = Bukkit.getScheduler();
        if (this.delayTicks != 0L) {
            if (this.period != 0L) {
                if (this.taskConsumer != null) {
                    scheduler.runTaskTimer(this.plugin, this::accept, this.delayTicks, this.period);
                    return null;
                }
                return new SpigotScheduledTask(scheduler.runTaskTimer(this.plugin, this.task, this.delayTicks, this.period));
            }
            if (this.taskConsumer != null) {
                scheduler.runTaskLater(this.plugin, this::accept, this.delayTicks);
                return null;
            }
            return new SpigotScheduledTask(scheduler.runTaskLater(this.plugin, this.task, this.delayTicks));
        }
        if (this.taskConsumer != null) {
            scheduler.runTask(this.plugin, this::accept);
            return null;
        }
        return new SpigotScheduledTask(scheduler.runTask(this.plugin, this.task));
    }

    @Nullable
    private TaskImpl<Plugin> newBukkitAsyncTask() {
        @NotNull BukkitScheduler scheduler = Bukkit.getScheduler();
        if (this.delayTicks != 0L) {
            if (this.period != 0L) {
                if (this.taskConsumer != null) {
                    scheduler.runTaskTimerAsynchronously(this.plugin, this::accept, this.delayTicks, this.period);
                    return null;
                }
                return new SpigotScheduledTask(scheduler.runTaskTimerAsynchronously(this.plugin, this.task, this.delayTicks, this.period));
            }
            if (this.taskConsumer != null) {
                scheduler.runTaskLaterAsynchronously(this.plugin, this::accept, this.delayTicks);
                return null;
            }
            return new SpigotScheduledTask(scheduler.runTaskLaterAsynchronously(this.plugin, this.task, this.delayTicks));
        }
        if (this.taskConsumer != null) {
            scheduler.runTaskAsynchronously(this.plugin, this::accept);
            return null;
        }
        return new SpigotScheduledTask(scheduler.runTaskAsynchronously(this.plugin, this.task));
    }
}

