/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.base.parse.network;

import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import org.jetbrains.annotations.NotNull;

public class NetworkParser {
    public static boolean isPrivateIp(InetAddress address) {
        return address.isAnyLocalAddress() || address.isLoopbackAddress() || address.isLinkLocalAddress() || address.isSiteLocalAddress() || NetworkParser.isNatRange(address);
    }

    public static boolean isPrivateIp(String address) throws UnknownHostException {
        return NetworkParser.isPrivateIp(InetAddress.getByName(address));
    }

    public static boolean isNatRange(InetAddress address) {
        byte[] bytes = address.getAddress();
        if (bytes.length == 4) {
            int firstOctet = bytes[0] & 0xFF;
            int secondOctet = bytes[1] & 0xFF;
            int prefix = firstOctet << 8 | secondOctet;
            return prefix >= 25664 && prefix <= 25727;
        }
        return false;
    }

    public static InputStream resource(@NotNull String filename) {
        try {
            URL url = Resources.getResource((String)filename);
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException ex) {
            return null;
        }
    }
}

