/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.base.player;

import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import one.tranic.t.base.TBase;
import one.tranic.t.base.player.BedrockPlayer;
import one.tranic.t.base.player.Location;
import org.geysermc.cumulus.form.Form;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Player<C> {
    public String getUsername();

    public UUID getUniqueId();

    @Nullable
    default public String getXUID() {
        return this.isBedrockPlayer() ? BedrockPlayer.getXUID(this.getUniqueId()) : null;
    }

    public String getConnectHost();

    default public boolean sendForm(Form form) {
        return BedrockPlayer.sendForm(this.getUniqueId(), form);
    }

    default public CompletableFuture<Boolean> sendFormAsync(Form form) {
        return TBase.runAsync(() -> this.sendForm(form));
    }

    default public boolean isBedrockPlayer() {
        return BedrockPlayer.isBedrockPlayer(this.getUniqueId());
    }

    public Locale getLocale();

    @Nullable
    public Location getLocation();

    public long getPing();

    public boolean isOnline();

    @Nullable
    public String getClientBrand();

    public C getSourcePlayer();

    public boolean kick();

    public boolean kick(String var1);

    public boolean kick(@NotNull Component var1);

    public void sendMessage(String var1);

    public void sendMessage(@NotNull Component var1);
}

