/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.util;

import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class Collections {
    private static boolean fastutil = false;

    public static <K> Map<K, Integer> newIntHashMap() {
        return fastutil ? new Object2IntOpenHashMap() : new HashMap();
    }

    public static <K> Map<K, Integer> newIntHashMap(@Range(from=0L, to=0x7FFFFFFFL) int initialCapacity) {
        return fastutil ? new Object2IntOpenHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public static <K> Map<K, Long> newLongHashMap() {
        return fastutil ? new Object2LongOpenHashMap() : new HashMap();
    }

    public static <K> Map<K, Long> newLongHashMap(@Range(from=0L, to=0x7FFFFFFFL) int initialCapacity) {
        return fastutil ? new Object2LongOpenHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public static <K> Map<K, Float> newFloatHashMap() {
        return fastutil ? new Object2FloatOpenHashMap() : new HashMap();
    }

    public static <K> Map<K, Float> newFloatHashMap(@Range(from=0L, to=0x7FFFFFFFL) int initialCapacity) {
        return fastutil ? new Object2FloatOpenHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public static <K> Map<K, Double> newDoubleHashMap() {
        return fastutil ? new Object2DoubleOpenHashMap() : new HashMap();
    }

    public static <K> Map<K, Double> newDoubleHashMap(@Range(from=0L, to=0x7FFFFFFFL) int initialCapacity) {
        return fastutil ? new Object2DoubleOpenHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public static <K> Map<K, Boolean> newBooleanHashMap() {
        return fastutil ? new Object2BooleanOpenHashMap() : new HashMap();
    }

    public static <K> Map<K, Boolean> newBooleanHashMap(@Range(from=0L, to=0x7FFFFFFFL) int initialCapacity) {
        return fastutil ? new Object2BooleanOpenHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public static <K, V> Map<K, V> newHashMap() {
        return fastutil ? new Object2ObjectOpenHashMap() : new HashMap();
    }

    public static <K, V> Map<K, V> newHashMap(@Range(from=0L, to=0x7FFFFFFFL) int initialCapacity) {
        return fastutil ? new Object2ObjectOpenHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public static <K, V> Map<K, V> newHashMap(@NotNull Map<K, V> map) {
        return fastutil ? new Object2ObjectOpenHashMap(map) : new HashMap<K, V>(map);
    }

    public static <T> Set<T> newHashSet() {
        return fastutil ? new ObjectOpenHashSet() : new HashSet();
    }

    public static <T> Set<T> newUnmodifiableHashSet() {
        return fastutil ? ObjectSet.of() : java.util.Collections.unmodifiableSet(new HashSet());
    }

    public static <T> Set<T> newUnmodifiableHashSet(@NotNull Set<T> set) {
        return fastutil ? ObjectSet.of((Object[])set.toArray()) : java.util.Collections.unmodifiableSet(set);
    }

    @SafeVarargs
    public static <T> Set<T> newUnmodifiableHashSet(T ... elements) {
        if (fastutil) {
            return ObjectSet.of((Object[])elements);
        }
        ArrayList list = new ArrayList(elements.length);
        java.util.Collections.addAll(list, elements);
        return Set.copyOf(list);
    }

    public static <T> Set<T> newHashSet(@Range(from=0L, to=0x7FFFFFFFL) int initialCapacity) {
        return fastutil ? new ObjectOpenHashSet(initialCapacity) : new HashSet(initialCapacity);
    }

    public static <T> Set<T> newTreeSet(Collection<? extends T> c) {
        return fastutil ? new ObjectAVLTreeSet(c) : new TreeSet<T>(c);
    }

    public static <T> Set<T> newTreeSetRB(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) Collection<? extends T> c) {
        return fastutil ? new ObjectRBTreeSet(c) : new TreeSet<T>(c);
    }

    public static <T> List<T> newArrayList() {
        return fastutil ? new ObjectArrayList() : new ArrayList();
    }

    public static <T> List<T> newUnmodifiableList() {
        return fastutil ? ObjectList.of() : java.util.Collections.unmodifiableList(new ArrayList());
    }

    public static <T> List<T> newUnmodifiableList(@NotNull List<T> list) {
        return fastutil ? ObjectList.of((Object[])list.toArray()) : java.util.Collections.unmodifiableList(list);
    }

    @SafeVarargs
    public static <T> List<T> newUnmodifiableList(T ... elements) {
        if (fastutil) {
            return ObjectList.of((Object[])elements);
        }
        ArrayList list = new ArrayList(elements.length);
        java.util.Collections.addAll(list, elements);
        return java.util.Collections.unmodifiableList(list);
    }

    public static <T> List<T> newArrayList(@Range(from=0L, to=0x7FFFFFFFL) int size) {
        return fastutil ? new ObjectArrayList(size) : new ArrayList(size);
    }

    @SafeVarargs
    public static <T> List<T> newArrayList(T ... elements) {
        if (fastutil) {
            return new ObjectArrayList((Object[])elements);
        }
        ArrayList list = new ArrayList(elements.length);
        java.util.Collections.addAll(list, elements);
        return list;
    }

    public static <T> List<T> newArrayList(@NotNull Collection<? extends T> elements) {
        return fastutil ? new ObjectArrayList(elements) : new ArrayList<T>(elements);
    }

    public static <K, V> void entryForEach(Map<K, V> map, Consumer<? super Map.Entry<K, V>> consumer) {
        if (fastutil && map instanceof Object2ObjectOpenHashMap) {
            Object2ObjectOpenHashMap fastMap = (Object2ObjectOpenHashMap)map;
            fastMap.object2ObjectEntrySet().fastForEach(consumer);
        } else {
            map.entrySet().forEach(consumer);
        }
    }

    public static <K, V> boolean removeIf(Map<K, V> map, Predicate<? super Map.Entry<K, V>> filter) {
        boolean bl;
        if (fastutil && map instanceof Object2ObjectOpenHashMap) {
            Object2ObjectOpenHashMap fastMap = (Object2ObjectOpenHashMap)map;
            bl = fastMap.object2ObjectEntrySet().removeIf(filter);
        } else {
            bl = map.entrySet().removeIf(filter);
        }
        return bl;
    }

    static {
        try {
            Class.forName("it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap");
            fastutil = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

