/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.base;

import java.lang.reflect.Method;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import one.tranic.t.base.command.Operator;
import one.tranic.t.base.command.source.CommandSource;
import one.tranic.t.util.Threads;

public class TBase {
    public static final ExecutorService executor = Threads.getExecutor();
    public static final CommandSource<?, ?> CONSOLE_SOURCE;
    private static final Operator operator;
    private static final String packageName;

    public static String getRootPath() {
        return TBase.getCurrentRootPackage(TBase.class);
    }

    public static String getCurrentRootPackage(Class<?> clazz) {
        String currentPackage = clazz.getPackageName();
        int lastDotIndex = currentPackage.lastIndexOf(46);
        if (lastDotIndex > 0) {
            return currentPackage.substring(0, lastDotIndex);
        }
        return currentPackage;
    }

    public static Operator console() {
        return operator;
    }

    private static CommandSource<?, ?> getConsoleSource() throws IllegalStateException {
        try {
            Class<?> commonClass = Class.forName(packageName + ".common.TCommon");
            Method method = commonClass.getDeclaredMethod("getConsoleSource", new Class[0]);
            method.setAccessible(true);
            return (CommandSource)method.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to access getConsoleSource via reflection", e);
        }
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable) {
        return CompletableFuture.runAsync(runnable, executor);
    }

    public static <T> CompletableFuture<T> runAsync(Supplier<T> supplier) {
        return CompletableFuture.supplyAsync(supplier, executor);
    }

    public static void close() {
        executor.shutdownNow();
    }

    static {
        operator = new Operator("Console", UUID.fromString("05b11eee-24db-4a21-ba9d-e12e8df9a92f"));
        packageName = TBase.getRootPath();
        CONSOLE_SOURCE = TBase.getConsoleSource();
    }
}

