/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.base.updater;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import one.tranic.t.base.TBase;
import one.tranic.t.base.parse.proxy.RequestWithProxyParser;

public class FetchVersion {
    private static final long CACHE_EXPIRY_MINUTES = 1440L;
    private static final String UPDATE_MESSAGE_TEMPLATE = "<aqua>[{plugin}]</aqua> <gold>The plugin has an update available, from </gold><aqua>{oldVersion}</aqua> <gold>to</gold> <aqua>{latestVersion}</aqua> <gold>, download address: </gold><aqua>{resourceURL}</aqua>";
    private final String pluginName;
    private final URL updateCheckURL;
    private final String currentVersion;
    private final String resourceURL;
    private final String noUpdateTemplate;
    private Future<?> future;
    private String latestVersion;
    private Date lastUpdateTime = new Date();

    public FetchVersion(String currentVersion, String pluginName, String resourceId) {
        this(currentVersion, pluginName, resourceId, null);
    }

    public FetchVersion(String currentVersion, String pluginName, String resourceId, String resourceURL) {
        this.currentVersion = currentVersion;
        this.pluginName = pluginName;
        try {
            this.updateCheckURL = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + resourceId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.resourceURL = Objects.requireNonNullElseGet(resourceURL, () -> "https://spigotmc.org/resources/" + resourceId);
        this.noUpdateTemplate = "<aqua>[" + pluginName + "]</aqua> <green> Already the latest version (or because of cache)</green>";
    }

    public void run() {
        this.stop();
        this.future = TBase.executor.submit(() -> {
            try {
                TimeUnit.HOURS.sleep(2L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.hasUpdate();
        });
    }

    public void stop() {
        if (this.future != null && !this.future.isCancelled()) {
            this.future.cancel(true);
        }
        this.future = null;
    }

    public Component getUpdateMessage() {
        String parsedMessage = UPDATE_MESSAGE_TEMPLATE.replace("{plugin}", this.pluginName).replace("{oldVersion}", this.currentVersion).replace("{latestVersion}", this.getLatestVersion()).replace("{resourceURL}", this.getResourceURL());
        return MiniMessage.miniMessage().deserialize((Object)parsedMessage);
    }

    public Component getNoUpdateMessage() {
        return MiniMessage.miniMessage().deserialize((Object)this.noUpdateTemplate);
    }

    public boolean isExpired() {
        long diffInMinutes = (new Date().getTime() - this.lastUpdateTime.getTime()) / 60000L;
        return diffInMinutes > 1440L;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public String getResourceURL() {
        return this.resourceURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUpdate() {
        if (this.latestVersion != null && !this.latestVersion.isBlank() && !this.isExpired()) {
            return !this.latestVersion.equals(this.currentVersion);
        }
        HttpURLConnection connection = null;
        try {
            connection = RequestWithProxyParser.openConnection(this.updateCheckURL);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                this.latestVersion = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        if (this.latestVersion == null || this.latestVersion.isEmpty()) {
            return false;
        }
        this.lastUpdateTime = new Date();
        return !this.latestVersion.equals(this.currentVersion);
    }
}

