/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.util;

import java.lang.reflect.Method;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import one.tranic.t.util.Sys;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Threads {
    private static final Method METHOD_OF_VIRTUAL;
    private static final Method METHOD_VIRTUAL_FACTORY;
    private static final Method METHOD_VIRTUAL_PER_TASK_EXECUTOR;

    public static ThreadFactory newVirtualThreadFactory() {
        return Threads.createVirtualThreadFactory();
    }

    public static ExecutorService newVirtualThreadPerTaskExecutor() {
        return Threads.createVirtualThreadPerTaskExecutor();
    }

    @NotNull
    public static ThreadFactory newVirtualThreadFactoryOrDefault() {
        ThreadFactory factory = Threads.createVirtualThreadFactory();
        return factory != null ? factory : Executors.defaultThreadFactory();
    }

    public static ExecutorService newVirtualThreadPerTaskExecutorOrProvided(ExecutorService fallbackExecutor) {
        ExecutorService executor = Threads.createVirtualThreadPerTaskExecutor();
        return executor != null ? executor : fallbackExecutor;
    }

    public static ExecutorService getExecutor() {
        return Threads.getExecutor(0, 4, 15L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    public static ExecutorService getExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        if (Threads.isVirtualThreadSupported() && METHOD_VIRTUAL_PER_TASK_EXECUTOR != null) {
            try {
                return (ExecutorService)METHOD_VIRTUAL_PER_TASK_EXECUTOR.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public static ExecutorService getPureExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Threads.newVirtualThreadFactoryOrDefault());
    }

    @Nullable
    private static ExecutorService createVirtualThreadPerTaskExecutor() {
        if (!Threads.isVirtualThreadSupported() || METHOD_VIRTUAL_PER_TASK_EXECUTOR == null) {
            return null;
        }
        try {
            return (ExecutorService)METHOD_VIRTUAL_PER_TASK_EXECUTOR.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private static ThreadFactory createVirtualThreadFactory() {
        if (!Threads.isVirtualThreadSupported() || METHOD_OF_VIRTUAL == null || METHOD_VIRTUAL_FACTORY == null) {
            return null;
        }
        try {
            Object builder = METHOD_OF_VIRTUAL.invoke(null, new Object[0]);
            return (ThreadFactory)METHOD_VIRTUAL_FACTORY.invoke(builder, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isVirtualThreadSupported() {
        return Sys.getCurrentJVMVersion() >= 21;
    }

    @Nullable
    private static Method getMethodWithFallback(Class<?> clazz, String methodName, boolean accessible) {
        try {
            Method method = clazz.getMethod(methodName, new Class[0]);
            if (accessible) {
                method.setAccessible(true);
            }
            return method;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private static Method getVirtualThreadFactoryMethod() {
        try {
            Method methodOfVirtual = Thread.class.getMethod("ofVirtual", new Class[0]);
            methodOfVirtual.setAccessible(true);
            Class<?> builderClass = Class.forName("java.lang.Thread$Builder");
            Method factoryMethod = builderClass.getMethod("factory", new Class[0]);
            factoryMethod.setAccessible(true);
            return factoryMethod;
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        boolean virtualSupported = Threads.isVirtualThreadSupported();
        METHOD_OF_VIRTUAL = virtualSupported ? Threads.getMethodWithFallback(Thread.class, "ofVirtual", true) : null;
        METHOD_VIRTUAL_FACTORY = virtualSupported ? Threads.getVirtualThreadFactoryMethod() : null;
        METHOD_VIRTUAL_PER_TASK_EXECUTOR = virtualSupported ? Threads.getMethodWithFallback(Executors.class, "newVirtualThreadPerTaskExecutor", true) : null;
    }
}

