/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.base.message;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import one.tranic.t.base.message.MessageImpl;
import one.tranic.t.util.Collections;
import one.tranic.t.util.Platform;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;

public class Message {
    private static final Map<Object, String> messages = Collections.newHashMap();
    private static final List<Locale> supportedLocales = Collections.newArrayList();
    private static MessageImpl messageImpl;

    public static MessageImpl getMessageImpl() {
        return messageImpl;
    }

    public static void setMessageImpl(MessageImpl messageImpl) {
        Message.messageImpl = messageImpl;
    }

    public static Map<Object, String> getMessages() {
        return messages;
    }

    public static List<Locale> getSupportedLocales() {
        return supportedLocales;
    }

    public static void setMessage(Object key, String message) {
        messages.put(key, message);
    }

    public static String getMessage(Object key) {
        return messages.get(key);
    }

    public static void loadAllMessage(@NotNull Object object) {
        Validate.notNull((Object)object, (String)"Object cannot be null");
        messageImpl.loadAllMessage(object);
    }

    public static void reloadMessages() {
        messageImpl.reloadMessages();
    }

    public boolean registerLocale(Locale locale) {
        return supportedLocales.add(locale);
    }

    public boolean isSupportedLocale(Locale locale) {
        return supportedLocales.contains(locale);
    }

    public void resetMessages() {
        messages.clear();
    }

    public void resetSupportedLocales() {
        supportedLocales.clear();
    }

    public static String toString(@NotNull Component component) {
        return LegacyComponentSerializer.legacySection().serialize(component);
    }

    public static BaseComponent[] toBaseComponent(@NotNull String message) {
        Validate.notNull((Object)message, (String)"Message cannot be null");
        if (Platform.get() != Platform.BungeeCord) {
            return null;
        }
        return TextComponent.fromLegacyText((String)message);
    }

    public static BaseComponent[] toBaseComponent(@NotNull Component component) {
        Validate.notNull((Object)component, (String)"Component cannot be null");
        if (Platform.get() != Platform.BungeeCord) {
            return null;
        }
        return Message.toBaseComponent(Message.toString(component));
    }
}

