/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.base.parse.mojang;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import one.tranic.t.base.parse.mojang.schemas.ProfileLookup;
import one.tranic.t.base.parse.proxy.RequestWithProxyParser;
import one.tranic.t.base.parse.uuid.UUIDParser;

public class MojangAPIParser {
    private static final Gson gson = new Gson();
    private static final String BASE_URL = "https://api.minecraftservices.com/minecraft/profile/lookup";

    public static ProfileLookup lookupProfile(String name) throws IOException {
        String url = "https://api.minecraftservices.com/minecraft/profile/lookup/name/" + name;
        HttpURLConnection connection = RequestWithProxyParser.openConnection(url);
        return MojangAPIParser.requestAndParse(connection, ProfileLookup.class);
    }

    public static ProfileLookup lookupProfile(UUID uuid) throws IOException {
        String url = "https://api.minecraftservices.com/minecraft/profile/lookup/" + UUIDParser.removeDashes(uuid);
        HttpURLConnection connection = RequestWithProxyParser.openConnection(url);
        return MojangAPIParser.requestAndParse(connection, ProfileLookup.class);
    }

    public static List<ProfileLookup> lookupProfile(String ... names) throws IOException {
        String url = "https://api.minecraftservices.com/minecraft/profile/lookup/bulk/byname";
        HttpURLConnection connection = RequestWithProxyParser.openConnection(url);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setDoOutput(true);
        String jsonBody = gson.toJson((Object)names);
        try (OutputStream outputStream = connection.getOutputStream();){
            outputStream.write(jsonBody.getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
        }
        Type listType = new TypeToken<List<ProfileLookup>>(){}.getType();
        return (List)MojangAPIParser.requestAndParse(connection, listType);
    }

    private static <T> T requestAndParse(HttpURLConnection connection, Type typeOfT) throws IOException {
        try {
            Object object;
            try (InputStreamReader reader = new InputStreamReader(connection.getInputStream());){
                object = gson.fromJson((Reader)reader, typeOfT);
            }
            return (T)object;
        }
        finally {
            connection.disconnect();
        }
    }

    private static <T> T requestAndParse(HttpURLConnection connection, Class<T> classOfT) throws IOException {
        return MojangAPIParser.requestAndParse(connection, classOfT);
    }
}

