/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.base.parse.proxy;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Map;
import one.tranic.t.base.parse.proxy.RegistryReader;
import one.tranic.t.util.Collections;
import org.jetbrains.annotations.Nullable;

public class ProxyConfigReader {
    public static Proxy getProxy(Proxy proxy) {
        if (proxy.equals(Proxy.NO_PROXY)) {
            return ProxyConfigReader.getProxy();
        }
        return proxy;
    }

    public static Proxy getProxy() {
        ProxyConfig config = ProxyConfigReader.getProxyConfig();
        if (!config.isStaticActive || config.protocols.isEmpty()) {
            return Proxy.NO_PROXY;
        }
        String protocol = config.protocols.containsKey("https") ? "https" : "http";
        String proxyAddress = config.protocols.get(protocol);
        String[] proxyParts = proxyAddress.split(":");
        String host = proxyParts[0];
        int port = proxyParts.length > 1 ? Integer.parseInt(proxyParts[1]) : 8080;
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
    }

    public static ProxyConfig getProxyConfig() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return ProxyConfigReader.getWindowsProxyConfig();
        }
        return ProxyConfigReader.getLinuxProxyConfig();
    }

    @Nullable
    private static ProxyConfig getWindowsProxyConfig() {
        ProxyConfig config = new ProxyConfig();
        try {
            RegistryReader.ProxySettings proxyMap = RegistryReader.readWindowsProxySettings();
            config.isStaticActive = proxyMap.enabled();
            config.protocols.put("http", proxyMap.server());
            config.noProxy = proxyMap.override();
        }
        catch (Exception e) {
            return null;
        }
        return config;
    }

    private static ProxyConfig getLinuxProxyConfig() {
        ProxyConfig config = new ProxyConfig();
        try {
            String httpProxy = System.getenv("http_proxy");
            String httpsProxy = System.getenv("https_proxy");
            String noProxy = System.getenv("no_proxy");
            boolean bl = config.isStaticActive = httpProxy != null || httpsProxy != null;
            if (httpProxy != null) {
                config.protocols.put("http", httpProxy);
            }
            if (httpsProxy != null) {
                config.protocols.put("https", httpsProxy);
            }
            config.noProxy = noProxy;
        }
        catch (Exception e) {
            return null;
        }
        return config;
    }

    public static class ProxyConfig {
        public boolean isStaticActive = false;
        public Map<String, String> protocols = Collections.newHashMap();
        public String noProxy = null;
        public boolean isAutomaticActive = false;
        public String preConfiguredURL = null;

        public String toString() {
            return "ProxyConfig{isStaticActive=" + this.isStaticActive + ", protocols=" + this.protocols + ", noProxy='" + this.noProxy + "', isAutomaticActive=" + this.isAutomaticActive + ", preConfiguredURL='" + this.preConfiguredURL + "'}";
        }
    }
}

