/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.base.parse.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.concurrent.Future;
import one.tranic.t.base.TBase;
import one.tranic.t.base.parse.proxy.ProxyConfigReader;

public class RequestWithProxyParser {
    private static Proxy proxy = ProxyConfigReader.getProxy();

    public static void setCustomProxy(Proxy proxy) {
        RequestWithProxyParser.proxy = proxy;
    }

    public static void refreshProxy() {
        proxy = ProxyConfigReader.getProxy();
    }

    public static Future<HttpURLConnection> openConnectionAsync(URL url) throws IOException {
        return TBase.executor.submit(() -> {
            try {
                return RequestWithProxyParser.openConnection(url);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static Future<HttpURLConnection> openConnectionAsync(String url) throws IOException {
        return RequestWithProxyParser.openConnectionAsync(new URL(url));
    }

    public static HttpURLConnection openConnection(String url) throws IOException {
        return RequestWithProxyParser.openConnection(new URL(url));
    }

    public static HttpURLConnection openConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection(proxy);
    }

    public static InputStream openStream(URL url) throws IOException {
        return url.openConnection(proxy).getInputStream();
    }

    public static InputStream openStream(String url) throws IOException {
        return RequestWithProxyParser.openStream(new URL(url));
    }

    public static Future<InputStream> openStreamAsync(URL url) throws IOException {
        return TBase.executor.submit(() -> {
            try {
                return RequestWithProxyParser.openStream(url);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static Future<InputStream> openStreamAsync(String url) throws IOException {
        return RequestWithProxyParser.openStreamAsync(new URL(url));
    }
}

