/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.base.player;

import java.util.UUID;
import one.tranic.t.base.parse.uuid.UUIDParser;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.cumulus.form.Form;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.geyser.api.GeyserApi;
import org.geysermc.geyser.api.connection.GeyserConnection;

public class BedrockPlayer {
    private static boolean geyser = false;
    private static boolean floodgate = false;

    public static boolean isBedrockPlayer(UUID uuid) {
        if (floodgate) {
            return FloodgateApi.getInstance().isFloodgatePlayer(uuid);
        }
        if (geyser) {
            return GeyserApi.api().isBedrockPlayer(uuid);
        }
        return BedrockPlayer.isFloodgatePlayer(uuid);
    }

    public static boolean isFloodgatePlayer(String uuid) {
        String FLOODGATE_UUID_PREFIX = "0000000000000000";
        String str = UUIDParser.removeDashes(uuid);
        return str.startsWith("0000000000000000");
    }

    public static boolean isFloodgatePlayer(UUID uuid) {
        return BedrockPlayer.isFloodgatePlayer(uuid.toString());
    }

    public static @NonNull String getPlatform(UUID uuid) {
        GeyserConnection player;
        if (floodgate) {
            FloodgatePlayer player2 = FloodgateApi.getInstance().getPlayer(uuid);
            if (player2 != null) {
                return player2.getDeviceOs().toString();
            }
        } else if (geyser && (player = GeyserApi.api().connectionByUuid(uuid)) != null) {
            return player.platform().toString();
        }
        return "Java Edition";
    }

    public static @Nullable String getXUID(UUID uuid) {
        GeyserConnection player;
        if (floodgate) {
            FloodgatePlayer player2 = FloodgateApi.getInstance().getPlayer(uuid);
            if (player2 != null) {
                return player2.getXuid();
            }
        } else if (geyser && (player = GeyserApi.api().connectionByUuid(uuid)) != null) {
            return player.xuid();
        }
        return null;
    }

    public static boolean sendForm(UUID uuid, Form form) {
        if (floodgate) {
            return FloodgateApi.getInstance().sendForm(uuid, form);
        }
        if (geyser) {
            return GeyserApi.api().sendForm(uuid, form);
        }
        return false;
    }

    public static long getPing(UUID uuid) {
        GeyserConnection geyserPlayer;
        if (geyser && (geyserPlayer = GeyserApi.api().connectionByUuid(uuid)) != null) {
            return geyserPlayer.ping();
        }
        return -1L;
    }

    public boolean hasGeyser() {
        return geyser;
    }

    public boolean hasFloodgate() {
        return floodgate;
    }

    static {
        try {
            Class.forName("org.geysermc.floodgate.api.FloodgateApi");
            floodgate = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("org.geysermc.geyser.api.GeyserApi");
            geyser = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

