/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.base.player;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import one.tranic.t.base.player.Player;
import one.tranic.t.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Players {
    private static Function<String, Player<?>> getPlayerWithStringMethod;
    private static Function<UUID, Player<?>> getPlayerWithUUIDMethod;
    private static Supplier<List<Player<?>>> getOnlinePlayersMethod;
    private static Supplier<List<?>> getPlatformOnlinePlayersMethod;
    private static Supplier<List<?>> getPlatformAltPlayersMethod;
    private static Supplier<List<String>> getOnlinePlayersNameMethod;

    @Nullable
    public static Player<?> getPlayer(@NotNull String name) {
        return getPlayerWithStringMethod.apply(name);
    }

    @Nullable
    public static Player<?> getPlayer(@NotNull UUID uuid) {
        return getPlayerWithUUIDMethod.apply(uuid);
    }

    @NotNull
    public static List<Player<?>> getOnlinePlayers() {
        return getOnlinePlayersMethod.get();
    }

    @NotNull
    public static List<Player<?>> getAltPlayers(@NotNull Player<?> player) {
        List<Player<?>> end = Collections.newArrayList();
        List<Player<?>> players = Players.getOnlinePlayers();
        for (Player<?> p : players) {
            if (p.getUniqueId() == player.getUniqueId() || !Objects.equals(p.getConnectedHost(), player.getConnectedHost())) continue;
            end.add(p);
        }
        return end;
    }

    @NotNull
    public static List<?> getPlatformAltPlayers() {
        return getPlatformAltPlayersMethod.get();
    }

    @NotNull
    public static List<?> getPlatformOnlinePlayers() {
        return getPlatformOnlinePlayersMethod.get();
    }

    @NotNull
    public static List<String> getOnlinePlayersName() {
        return getOnlinePlayersNameMethod.get();
    }
}

