/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.util;

import org.jetbrains.annotations.NotNull;

public enum Platform {
    Velocity,
    BungeeCord,
    Spigot,
    Paper,
    ShreddedPaper,
    Folia;

    private static Platform platform;

    @NotNull
    public static Platform get() {
        if (platform != null) {
            return platform;
        }
        try {
            Class.forName("com.velocitypowered.api.proxy.Player");
            platform = Velocity;
            return platform;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("net.md_5.bungee.api.CommandSender");
                platform = BungeeCord;
                return platform;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                try {
                    Class.forName("io.papermc.paper.threadedregions.commands.CommandServerHealth");
                    platform = Folia;
                    return platform;
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    try {
                        Class.forName("io.multipaper.shreddedpaper.threading.ShreddedPaperTickThread");
                        platform = ShreddedPaper;
                        return platform;
                    }
                    catch (ClassNotFoundException classNotFoundException4) {
                        try {
                            Class.forName("io.papermc.paper.util.MCUtil");
                            platform = Paper;
                            return platform;
                        }
                        catch (ClassNotFoundException classNotFoundException5) {
                            platform = Spigot;
                            return Spigot;
                        }
                    }
                }
            }
        }
    }

    @NotNull
    public static Platform of(@NotNull String name) {
        return switch (name.toLowerCase()) {
            case "velocity" -> Velocity;
            case "bungeecord" -> BungeeCord;
            case "spigot" -> Spigot;
            case "paper" -> Paper;
            case "shreddedpaper" -> ShreddedPaper;
            case "folia" -> Folia;
            default -> throw new IllegalArgumentException("Unknown platform: " + name);
        };
    }

    public static boolean isBukkit() {
        return Platform.get() == Paper || Platform.get() == Folia || Platform.get() == ShreddedPaper;
    }

    @NotNull
    public String toString() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case Velocity -> "velocity";
            case BungeeCord -> "bungeecord";
            case Spigot -> "spigot";
            case Paper -> "paper";
            case ShreddedPaper -> "shreddedpaper";
            case Folia -> "folia";
        };
    }

    @NotNull
    public String toRawString() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case Velocity -> "Velocity";
            case BungeeCord -> "BungeeCord";
            case Spigot -> "Spigot";
            case Paper -> "Paper";
            case ShreddedPaper -> "ShreddedPaper";
            case Folia -> "Folia";
        };
    }
}

