/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.base;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import one.tranic.t.base.command.Operator;
import one.tranic.t.base.command.source.SystemCommandSource;
import one.tranic.t.thread.T2hread;
import org.jetbrains.annotations.Nullable;

public class TBase {
    public static final ExecutorService executor = T2hread.getExecutor();
    private static final Operator operator = new Operator("Console", UUID.fromString("05b11eee-24db-4a21-ba9d-e12e8df9a92f"));
    private static final String packageName = TBase.getRootPath();
    private static SystemCommandSource<?, ?> CONSOLE_SOURCE;
    private static Supplier<SystemCommandSource<?, ?>> getConsoleSourceSupplier;

    public static String getRootPath() {
        if (packageName != null) {
            return packageName;
        }
        return TBase.getCurrentRootPackage(TBase.class);
    }

    public static String getCurrentRootPackage(Class<?> clazz) {
        String currentPackage = clazz.getPackageName();
        int lastDotIndex = currentPackage.lastIndexOf(46);
        if (lastDotIndex > 0) {
            return currentPackage.substring(0, lastDotIndex);
        }
        return currentPackage;
    }

    public static Operator console() {
        return operator;
    }

    @Nullable
    public static SystemCommandSource<?, ?> getConsoleSource() {
        if (CONSOLE_SOURCE != null) {
            return CONSOLE_SOURCE;
        }
        if (getConsoleSourceSupplier != null) {
            CONSOLE_SOURCE = getConsoleSourceSupplier.get();
            return CONSOLE_SOURCE;
        }
        return null;
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable) {
        return CompletableFuture.runAsync(runnable, executor);
    }

    public static <T> CompletableFuture<T> runAsync(Supplier<T> supplier) {
        return CompletableFuture.supplyAsync(supplier, executor);
    }

    public static void close() {
        executor.shutdownNow();
    }
}

