/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.base.parse.version;

import java.util.List;
import java.util.regex.Pattern;
import one.tranic.t.utils.Collections;

public class VersionComparator {
    private static final Pattern NUMERIC_PATTERN = Pattern.compile("\\d+");
    private static final String DEFAULT_VERSION_SEGMENT = "0";

    private static List<String> splitVersion(String version) {
        String mainVersion = version.split("-")[0].split("\\+")[0];
        Object[] versionParts = mainVersion.split("\\.");
        String suffix = version.contains("-") ? version.substring(version.indexOf(45) + 1) : "";
        List result = Collections.newArrayList((Object[])versionParts);
        result.add(suffix);
        return result;
    }

    private static int compareVersionSegments(String segment1, String segment2) {
        boolean isSegment1Numeric = NUMERIC_PATTERN.matcher(segment1).matches();
        boolean isSegment2Numeric = NUMERIC_PATTERN.matcher(segment2).matches();
        if (isSegment1Numeric && isSegment2Numeric) {
            return Integer.compare(Integer.parseInt(segment1), Integer.parseInt(segment2));
        }
        if (isSegment1Numeric) {
            return 1;
        }
        if (isSegment2Numeric) {
            return -1;
        }
        return segment1.compareToIgnoreCase(segment2);
    }

    public static int compareVersions(String localVersion, String remoteVersion) {
        List<String> localSegments = VersionComparator.splitVersion(localVersion);
        List<String> remoteSegments = VersionComparator.splitVersion(remoteVersion);
        int maxSegments = Math.max(localSegments.size(), remoteSegments.size());
        for (int i = 0; i < maxSegments; ++i) {
            String remotePart;
            String localPart = i < localSegments.size() ? localSegments.get(i) : DEFAULT_VERSION_SEGMENT;
            int comparisonResult = VersionComparator.compareVersionSegments(localPart, remotePart = i < remoteSegments.size() ? remoteSegments.get(i) : DEFAULT_VERSION_SEGMENT);
            if (comparisonResult == 0) continue;
            return comparisonResult;
        }
        return 0;
    }
}

