/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.base.parse.html;

import java.util.Base64;
import java.util.Map;
import one.tranic.t.utils.Collections;
import org.jetbrains.annotations.NotNull;

public class HTMLParser {
    private static final Map<String, String> HTML_ENTITY_UNESCAPE_MAP = Collections.newLinkedHashMap((int)5);

    public static String decodeAndStripHtml(String base64EncodedString) {
        return new String(Base64.getDecoder().decode(base64EncodedString)).replaceAll("<[^>]+>", "").replaceFirst("^\\s+", "");
    }

    public static String escapeHtml(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder escaped = new StringBuilder(input.length());
        for (char c : input.toCharArray()) {
            escaped.append(HTMLParser.getHtmlEscapedChar(c));
        }
        return escaped.toString();
    }

    private static String getHtmlEscapedChar(char c) {
        return switch (c) {
            case '&' -> "&amp;";
            case '<' -> "&lt;";
            case '>' -> "&gt;";
            case '\"' -> "&quot;";
            case '\'' -> "&#39;";
            default -> String.valueOf(c);
        };
    }

    @NotNull
    public static String clean(@NotNull String input) {
        if (input == null || input.isBlank()) {
            return input;
        }
        String BR_REGEX = "(?i)<br\\s*/?>";
        String HTML_TAG_REGEX = "<[^>]+>";
        String MULTIPLE_NEWLINES_REGEX = "\\n+";
        String MULTIPLE_SPACES_REGEX = " {2,}";
        String normalizedBreaks = input.replaceAll("(?i)<br\\s*/?>", "\n");
        String withoutHtmlTags = normalizedBreaks.replaceAll("<[^>]+>", "");
        String singleNewlines = withoutHtmlTags.replaceAll("\\n+", "\n");
        String singleSpaces = singleNewlines.replaceAll(" {2,}", " ");
        return singleSpaces.trim();
    }

    public static String unescapeHtml(String escapedString) {
        if (escapedString.indexOf(38) == -1) {
            return escapedString;
        }
        StringBuilder result = new StringBuilder(escapedString.length());
        int len = escapedString.length();
        for (int i = 0; i < len; ++i) {
            String entity;
            String replacement;
            int semicolonIndex;
            char current = escapedString.charAt(i);
            if (current == '&' && (semicolonIndex = escapedString.indexOf(59, i)) > i && (replacement = HTML_ENTITY_UNESCAPE_MAP.get(entity = escapedString.substring(i, semicolonIndex + 1))) != null) {
                result.append(replacement);
                i = semicolonIndex;
                continue;
            }
            result.append(current);
        }
        return result.toString();
    }

    static {
        HTML_ENTITY_UNESCAPE_MAP.put("&lt;", "<");
        HTML_ENTITY_UNESCAPE_MAP.put("&gt;", ">");
        HTML_ENTITY_UNESCAPE_MAP.put("&quot;", "\"");
        HTML_ENTITY_UNESCAPE_MAP.put("&#39;", "'");
        HTML_ENTITY_UNESCAPE_MAP.put("&amp;", "&");
    }
}

