/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.base.parse.mojang;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import one.tranic.t.base.parse.json.JsonParser;
import one.tranic.t.base.parse.mojang.schemas.ProfileLookup;
import one.tranic.t.base.parse.uuid.UUIDParser;
import one.tranic.t.proxy.RequestWithProxyParser;

public class MojangAPIParser {
    private static final String BASE_URL = "https://api.minecraftservices.com/minecraft/profile/lookup";
    private static final String NAME_ENDPOINT = "/name/";
    private static final String BULK_ENDPOINT = "/bulk/byname";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_JSON = "application/json";
    private static final String POST_METHOD = "POST";

    public static ProfileLookup lookupProfile(String name) throws IOException {
        return MojangAPIParser.lookupProfile(true, name);
    }

    public static ProfileLookup lookupProfile(boolean useProxy, String name) throws IOException {
        String url = "https://api.minecraftservices.com/minecraft/profile/lookup/name/" + name;
        HttpURLConnection connection = MojangAPIParser.createConnection(url, useProxy);
        return JsonParser.requestAndParse(connection, ProfileLookup.class);
    }

    public static ProfileLookup lookupProfile(UUID uuid) throws IOException {
        return MojangAPIParser.lookupProfile(true, uuid);
    }

    public static ProfileLookup lookupProfile(boolean useProxy, UUID uuid) throws IOException {
        String url = "https://api.minecraftservices.com/minecraft/profile/lookup/" + UUIDParser.removeDashes(uuid);
        HttpURLConnection connection = MojangAPIParser.createConnection(url, useProxy);
        return JsonParser.requestAndParse(connection, ProfileLookup.class);
    }

    public static List<ProfileLookup> lookupProfiles(String ... names) throws IOException {
        return MojangAPIParser.lookupProfiles(true, names);
    }

    public static List<ProfileLookup> lookupProfiles(boolean useProxy, String ... names) throws IOException {
        String url = "https://api.minecraftservices.com/minecraft/profile/lookup/bulk/byname";
        HttpURLConnection connection = MojangAPIParser.createConnection(url, useProxy);
        connection.setRequestMethod(POST_METHOD);
        connection.setRequestProperty(CONTENT_TYPE, APPLICATION_JSON);
        connection.setDoOutput(true);
        String jsonBody = JsonParser.toJson(names);
        try (OutputStream outputStream = connection.getOutputStream();){
            outputStream.write(jsonBody.getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
        }
        Type listType = new TypeToken<List<ProfileLookup>>(){}.getType();
        return (List)JsonParser.requestAndParse(connection, listType);
    }

    private static HttpURLConnection createConnection(String url, boolean useProxy) throws IOException {
        return useProxy ? RequestWithProxyParser.openConnection((String)url) : (HttpURLConnection)new URL(url).openConnection(Proxy.NO_PROXY);
    }
}

