/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.base.updater;

import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Objects;
import one.tranic.t.base.parse.json.JsonParser;
import one.tranic.t.base.updater.VersionFetcher;
import one.tranic.t.base.updater.schemas.modrinth.Loaders;
import one.tranic.t.base.updater.schemas.modrinth.ModrinthVersionSource;
import one.tranic.t.proxy.RequestWithProxyParser;

public class ModrinthVersionFetcher
extends VersionFetcher {
    private static final String MODRINTH_PROJECT_URL = "https://modrinth.com/project/";
    private final String expectedLoader;

    public ModrinthVersionFetcher(String currentVersion, String pluginName, String slug, Loaders loaders) {
        super(currentVersion, pluginName, "https://api.modrinth.com/v2/project/" + slug + "/version", MODRINTH_PROJECT_URL + slug);
        this.expectedLoader = loaders.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String fetchLatestVersion() {
        block15: {
            HttpURLConnection connection = null;
            try {
                connection = RequestWithProxyParser.openConnection((URL)this.updateCheckURL);
                InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                ModrinthVersionSource[] versions = JsonParser.fromJson(reader, ModrinthVersionSource[].class);
                if (versions.length == 0) {
                    String string = null;
                    return string;
                }
                ModrinthVersionSource latestVersion = versions[0];
                if (!this.hasCompatibleLoader(latestVersion) || Objects.equals(this.currentVersion, latestVersion.getVersionNumber())) break block15;
                this.updateResourceURL(MODRINTH_PROJECT_URL + latestVersion.getProjectId() + "/version/" + latestVersion.getVersionNumber());
                String string = latestVersion.getVersionNumber();
                return string;
                finally {
                    reader.close();
                }
            }
            catch (Exception e) {
                String string = null;
                return string;
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        return null;
    }

    private boolean hasCompatibleLoader(ModrinthVersionSource version) {
        for (String loader : version.getLoaders()) {
            if (!Objects.equals(loader, this.expectedLoader)) continue;
            return true;
        }
        return false;
    }
}

