/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.base.updater;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import one.tranic.t.proxy.RequestWithProxyParser;
import one.tranic.t.thread.T2hread;
import org.jetbrains.annotations.NotNull;

public abstract class VersionFetcher
implements AutoCloseable,
Runnable {
    private static final long CACHE_EXPIRY_MINUTES = 1440L;
    private static final int SLEEP_HOURS = 2;
    private static final String UPDATE_MESSAGE_TEMPLATE = "<aqua>[{plugin}]</aqua> <gold>The plugin has an update available, from </gold><aqua>{oldVersion}</aqua> <gold>to</gold> <aqua>{latestVersion}</aqua> <gold>, download address: </gold><aqua>{resourceURL}</aqua>";
    final URL updateCheckURL;
    final String currentVersion;
    private final String pluginName;
    private final String noUpdateTemplate;
    private String resourceURL;
    private Thread updateThread;
    private String latestVersion;
    private Date lastUpdateTime = new Date();

    public VersionFetcher(String currentVersion, String pluginName, String api) {
        this(currentVersion, pluginName, api, null);
    }

    public VersionFetcher(String currentVersion, String pluginName, String api, String resourceURL) {
        this.currentVersion = currentVersion;
        this.pluginName = pluginName;
        try {
            this.updateCheckURL = new URL(api);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.resourceURL = Objects.requireNonNullElse(resourceURL, "https://spigotmc.org/resources/");
        this.noUpdateTemplate = "<aqua>[" + pluginName + "]</aqua> <green> Already the latest version (or because of cache)</green>";
    }

    @Override
    public void run() {
        try {
            this.hasUpdate();
            while (true) {
                TimeUnit.HOURS.sleep(2L);
                this.hasUpdate();
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public void start() {
        this.close();
        this.updateThread = T2hread.newThread((Runnable)this, (String)"FetchVersion-Thread", (boolean)true);
        this.updateThread.start();
    }

    @Override
    public void close() {
        if (this.updateThread != null && this.updateThread.isAlive()) {
            this.updateThread.interrupt();
        }
        this.updateThread = null;
    }

    @NotNull
    public Component getUpdateMessage() {
        String parsedMessage = UPDATE_MESSAGE_TEMPLATE.replace("{plugin}", this.pluginName).replace("{oldVersion}", this.currentVersion).replace("{latestVersion}", this.getLatestVersion()).replace("{resourceURL}", this.getResourceURL());
        return MiniMessage.miniMessage().deserialize((Object)parsedMessage);
    }

    public Component getNoUpdateMessage() {
        return MiniMessage.miniMessage().deserialize((Object)this.noUpdateTemplate);
    }

    public boolean isExpired() {
        long diffInMinutes = (new Date().getTime() - this.lastUpdateTime.getTime()) / 60000L;
        return diffInMinutes > 1440L;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public String getResourceURL() {
        return this.resourceURL;
    }

    public void updateResourceURL(String resourceURL) {
        this.resourceURL = resourceURL;
    }

    public boolean hasUpdate() {
        if (this.latestVersion != null && !this.latestVersion.isBlank() && !this.isExpired()) {
            return !this.latestVersion.equals(this.currentVersion);
        }
        String fetchedVersion = this.fetchLatestVersion();
        if (fetchedVersion == null || fetchedVersion.isEmpty()) {
            return false;
        }
        this.latestVersion = fetchedVersion;
        this.lastUpdateTime = new Date();
        return !this.latestVersion.equals(this.currentVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fetchLatestVersion() {
        HttpURLConnection connection = null;
        try {
            String string;
            connection = RequestWithProxyParser.openConnection((URL)this.updateCheckURL);
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            try {
                string = reader.readLine();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    String string2 = null;
                    return string2;
                }
            }
            reader.close();
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

