/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.base.updater.schemas.modrinth;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import one.tranic.t.base.updater.schemas.modrinth.Loaders;
import one.tranic.t.base.updater.schemas.modrinth.RequestedStatus;
import one.tranic.t.base.updater.schemas.modrinth.Status;
import org.jetbrains.annotations.Nullable;

public class ModrinthVersionSource {
    private String name;
    @SerializedName(value="version_number")
    private String versionNumber;
    private String changelog;
    private List<Dependency> dependencies;
    @SerializedName(value="game_versions")
    private List<String> gameVersions;
    @SerializedName(value="version_type")
    private String versionType;
    private List<String> loaders;
    private boolean featured;
    private String status;
    @SerializedName(value="requested_status")
    private String requestedStatus;
    private String id;
    @SerializedName(value="project_id")
    private String projectId;
    @SerializedName(value="author_id")
    private String authorId;
    @SerializedName(value="date_published")
    private String datePublished;
    private int downloads;
    @SerializedName(value="changelog_url")
    private String changelogUrl;
    private List<File> files;

    public String getName() {
        return this.name;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public String getChangelog() {
        return this.changelog;
    }

    @Nullable
    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public List<String> getGameVersions() {
        return this.gameVersions;
    }

    public String getVersionType() {
        return this.versionType;
    }

    public List<String> getLoaders() {
        return this.loaders;
    }

    public List<Loaders> getLoadersOf() {
        ArrayList<Loaders> list = new ArrayList<Loaders>(this.loaders.size());
        for (String loader : this.loaders) {
            list.add(Loaders.of(loader));
        }
        return list;
    }

    public boolean isFeatured() {
        return this.featured;
    }

    public Status getStatus() {
        return Status.of(this.status);
    }

    @Nullable
    public RequestedStatus getRequestedStatus() {
        return RequestedStatus.of(this.requestedStatus);
    }

    public String getId() {
        return this.id;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getAuthorId() {
        return this.authorId;
    }

    public String getDatePublished() {
        return this.datePublished;
    }

    public int getDownloads() {
        return this.downloads;
    }

    @Nullable
    public String getChangelogUrl() {
        return this.changelogUrl;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public static class Hashes {
        private String sha512;
        private String sha1;

        public String getSha512() {
            return this.sha512;
        }

        public String getSha1() {
            return this.sha1;
        }
    }

    public static class File {
        private Hashes hashes;
        private String url;
        private String filename;
        private boolean primary;
        private int size;
        @SerializedName(value="file_type")
        private String fileType;

        public Hashes getHashes() {
            return this.hashes;
        }

        public String getUrl() {
            return this.url;
        }

        public String getFilename() {
            return this.filename;
        }

        public boolean isPrimary() {
            return this.primary;
        }

        public int getSize() {
            return this.size;
        }

        @Nullable
        public String getFileType() {
            return this.fileType;
        }
    }

    public static class Dependency {
        @SerializedName(value="version_id")
        private String versionId;
        @SerializedName(value="project_id")
        private String projectId;
        @SerializedName(value="file_name")
        private String fileName;
        @SerializedName(value="dependency_type")
        private String dependencyType;

        public String getVersionId() {
            return this.versionId;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getDependencyType() {
            return this.dependencyType;
        }
    }
}

