/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.base.parse.json;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonParser {
    private static final Gson gson = new Gson();

    public static Gson gson() {
        return gson;
    }

    public static <T> T requestAndParse(HttpURLConnection connection, Type typeOfT) throws IOException {
        try {
            Object object;
            try (InputStreamReader reader = new InputStreamReader(connection.getInputStream());){
                object = gson.fromJson((Reader)reader, typeOfT);
            }
            return (T)object;
        }
        finally {
            connection.disconnect();
        }
    }

    public static <T> T requestAndParse(HttpURLConnection connection, Class<T> classOfT) throws IOException {
        return JsonParser.requestAndParse(connection, classOfT);
    }

    public static <T> T fromJson(@NotNull Reader json, @NotNull Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        return (T)gson.fromJson(json, classOfT);
    }

    public static String toJson(@Nullable Object src) {
        return gson.toJson(src);
    }
}

