/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.base.player;

import java.util.UUID;
import one.tranic.t.base.parse.uuid.UUIDParser;
import one.tranic.t.base.player.Player;
import one.tranic.t.utils.Reflect;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.cumulus.form.Form;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.player.FloodgatePlayerImpl;
import org.geysermc.geyser.api.GeyserApi;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.session.GeyserSession;
import org.jetbrains.annotations.NotNull;

public class BedrockPlayer {
    private static final boolean geyser = Reflect.hasClass((String)"org.geysermc.geyser.api.GeyserApi");
    private static final boolean floodgate = Reflect.hasClass((String)"org.geysermc.floodgate.api.FloodgateApi");
    private final Player player;
    private final Object bedrockPlayer;

    protected BedrockPlayer(@NotNull Player player) {
        this.player = player;
        this.bedrockPlayer = BedrockPlayer.getBedrockPlayer(player.getUniqueId());
    }

    public static BedrockPlayer of(@NotNull Player player) {
        return new BedrockPlayer(player);
    }

    public static boolean isBedrockPlayer(UUID uuid) {
        if (floodgate) {
            return FloodgateApi.getInstance().isFloodgatePlayer(uuid);
        }
        if (geyser) {
            return GeyserApi.api().isBedrockPlayer(uuid);
        }
        return BedrockPlayer.isFloodgatePlayer(uuid);
    }

    public static boolean isFloodgatePlayer(String uuid) {
        String FLOODGATE_UUID_PREFIX = "0000000000000000";
        String str = UUIDParser.removeDashes(uuid);
        return str.startsWith("0000000000000000");
    }

    public static boolean isFloodgatePlayer(UUID uuid) {
        return BedrockPlayer.isFloodgatePlayer(uuid.toString());
    }

    private static @Nullable Object getBedrockPlayer(UUID uuid) {
        return floodgate ? FloodgateApi.getInstance().getPlayer(uuid) : (geyser ? GeyserApi.api().connectionByUuid(uuid) : null);
    }

    public static boolean hasGeyser() {
        return geyser;
    }

    public static boolean hasFloodgate() {
        return floodgate;
    }

    @NotNull
    public Player player() {
        return this.player;
    }

    public boolean isFloodgatePlayer() {
        return this.bedrockPlayer != null && floodgate && this.bedrockPlayer instanceof FloodgatePlayer;
    }

    public @NonNull String platform() {
        if (this.bedrockPlayer != null) {
            if (floodgate) {
                return ((FloodgatePlayer)this.bedrockPlayer).getDeviceOs().toString();
            }
            if (geyser) {
                return ((GeyserConnection)this.bedrockPlayer).platform().toString();
            }
        }
        return "Java Edition";
    }

    public int subscribeId() {
        if (this.bedrockPlayer != null && floodgate) {
            return ((FloodgatePlayerImpl)this.bedrockPlayer).getSubscribeId();
        }
        return -1;
    }

    public @Nullable String deviceId() {
        if (this.bedrockPlayer != null && geyser) {
            return ((GeyserSession)this.bedrockPlayer).getClientData().getDeviceId();
        }
        return null;
    }

    public @Nullable String deviceModel() {
        if (this.bedrockPlayer != null && geyser) {
            return ((GeyserSession)this.bedrockPlayer).getClientData().getDeviceModel();
        }
        return null;
    }

    public @Nullable String inputMode() {
        if (this.bedrockPlayer != null) {
            if (floodgate) {
                return ((FloodgatePlayer)this.bedrockPlayer).getInputMode().name();
            }
            if (geyser) {
                return ((GeyserConnection)this.bedrockPlayer).inputMode().name();
            }
        }
        return null;
    }

    public long clientID() {
        if (this.bedrockPlayer != null && geyser) {
            return ((GeyserSession)this.bedrockPlayer).getClientData().getClientRandomId();
        }
        return -1L;
    }

    public @Nullable String xuid() {
        if (this.bedrockPlayer != null) {
            if (floodgate) {
                return ((FloodgatePlayer)this.bedrockPlayer).getXuid();
            }
            if (geyser) {
                return ((GeyserConnection)this.bedrockPlayer).xuid();
            }
        }
        return null;
    }

    public boolean form(@NotNull Form form) {
        if (this.bedrockPlayer != null && form != null) {
            if (floodgate) {
                return ((FloodgatePlayer)this.bedrockPlayer).sendForm(form);
            }
            if (geyser) {
                return ((GeyserConnection)this.bedrockPlayer).sendForm(form);
            }
        }
        return false;
    }

    public long ping() {
        if (this.bedrockPlayer != null && geyser) {
            return ((GeyserConnection)this.bedrockPlayer).ping();
        }
        return -1L;
    }
}

