/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.base.player;

import java.util.Locale;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import one.tranic.t.base.TBase;
import one.tranic.t.base.player.BedrockPlayer;
import one.tranic.t.base.player.Location;
import one.tranic.t.base.player.ViaPlayer;
import one.tranic.t.utils.minecraft.ProtocolVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Player<C> {
    @Nullable
    public static Player<?> getPlayer(@NotNull String name) {
        return TBase.INSTANCE.getPlayer(name);
    }

    @Nullable
    public static Player<?> getPlayer(@NotNull UUID uuid) {
        return TBase.INSTANCE.getPlayer(uuid);
    }

    @Nullable
    default public BedrockPlayer toBedrockPlayer() {
        return BedrockPlayer.of(this);
    }

    @NotNull
    public String getUsername();

    @NotNull
    public UUID getUniqueId();

    default public int getPlayerProtocolVersion() {
        if (this.isBedrockPlayer()) {
            return -1;
        }
        return ViaPlayer.getVersion(this.getUniqueId());
    }

    @NotNull
    default public ProtocolVersion getPlayerVersion() {
        if (this.isBedrockPlayer()) {
            return ProtocolVersion.UNKNOWN;
        }
        return ProtocolVersion.fromProtocolVersion((int)ViaPlayer.getVersion(this.getUniqueId()));
    }

    @NotNull
    public String getConnectedHost();

    default public boolean isBedrockPlayer() {
        return BedrockPlayer.isBedrockPlayer(this.getUniqueId());
    }

    @NotNull
    public Locale getLocale();

    @Nullable
    public Location getLocation();

    public long getPing();

    public boolean isOnline();

    @Nullable
    public String getClientBrand();

    @Nullable
    public C getSourcePlayer();

    public boolean kick();

    public boolean kick(@Nullable String var1);

    public boolean kick(@NotNull Component var1);

    public void sendMessage(@NotNull String var1);

    public void sendMessage(@NotNull Component var1);
}

