/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.base;

import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import one.tranic.t.base.TInterface;
import one.tranic.t.base.command.Operator;
import one.tranic.t.base.command.source.SystemCommandSource;
import one.tranic.t.thread.T2hread;
import one.tranic.t.utils.minecraft.Platform;

public class TBase {
    public static final ExecutorService executor = T2hread.getExecutor();
    public static final TInterface INSTANCE;
    private static final Operator operator;
    private static final String packageName;
    private static SystemCommandSource<?, ?> CONSOLE_SOURCE;

    private static TInterface load() {
        ServiceLoader<TInterface> loader = ServiceLoader.load(TInterface.class);
        for (TInterface service : loader) {
            Platform[] platforms;
            for (Platform platform : platforms = service.getSupportedPlatforms()) {
                if (!platform.is()) continue;
                if (platform.isMixinServer()) continue;
                return service;
            }
        }
        throw new NullPointerException("Failed to load service for " + TInterface.class.getName());
    }

    public static String getRootPath() {
        if (packageName != null) {
            return packageName;
        }
        return TBase.getCurrentRootPackage(TBase.class);
    }

    public static String getCurrentRootPackage(Class<?> clazz) {
        String currentPackage = clazz.getPackageName();
        int lastDotIndex = currentPackage.lastIndexOf(46);
        if (lastDotIndex > 0) {
            return currentPackage.substring(0, lastDotIndex);
        }
        return currentPackage;
    }

    public static Operator console() {
        return operator;
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable) {
        return CompletableFuture.runAsync(runnable, executor);
    }

    public static <T> CompletableFuture<T> runAsync(Supplier<T> supplier) {
        return CompletableFuture.supplyAsync(supplier, executor);
    }

    public static void close() {
        executor.shutdownNow();
    }

    static {
        operator = new Operator("Console", UUID.fromString("05b11eee-24db-4a21-ba9d-e12e8df9a92f"));
        packageName = TBase.getRootPath();
        INSTANCE = TBase.load();
    }
}

