/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.base.parse.time;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import one.tranic.t.base.exception.ForeverNonException;
import one.tranic.t.base.exception.ParseException;
import one.tranic.t.base.parse.time.TimeUnit;

public class TimeParser {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static String parse(String arg) throws ParseException {
        if (arg == null || arg.isBlank()) {
            throw new ParseException("Time argument cannot be null, empty, or only whitespace.");
        }
        if (arg.equals("forever")) {
            return "forever";
        }
        try {
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime future = TimeParser.calculateFutureTime(now, arg);
            return future.format(FORMATTER);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Invalid numeric value in argument: '" + arg + "' - " + e.getMessage());
        }
    }

    private static LocalDateTime calculateFutureTime(LocalDateTime now, String arg) throws ParseException {
        for (TimeUnit unit : TimeUnit.values()) {
            if (!arg.endsWith(unit.getSuffix())) continue;
            long value = TimeParser.parseTimeValue(unit.getSuffix(), arg);
            return unit.addTime(now, value);
        }
        throw new ParseException("Invalid time format or unsupported time unit: " + arg);
    }

    private static long parseTimeValue(String tag, String arg) throws ParseException {
        if (!arg.endsWith(tag)) {
            throw new ParseException("Time unit '" + tag + "' not found at the end of argument: " + arg);
        }
        String numberPart = arg.substring(0, arg.length() - tag.length());
        long t = Long.parseLong(numberPart);
        if (t < 0L) {
            throw new ParseException("Time value cannot be negative: " + arg);
        }
        return t;
    }

    public static LocalDateTime parseStringTime(String timeString) throws ParseException, ForeverNonException {
        if (Objects.equals(timeString, "forever")) {
            throw new ForeverNonException();
        }
        try {
            return LocalDateTime.parse(timeString, FORMATTER);
        }
        catch (Exception e) {
            throw new ParseException("Invalid time string format: '" + timeString + "'");
        }
    }

    public static boolean isTimeInPast(LocalDateTime dateTime) {
        return dateTime.isBefore(LocalDateTime.now());
    }
}

