/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.base.parse.time;

import java.time.LocalDateTime;
import one.tranic.t.base.exception.ParseException;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TimeUnit {
    SECOND("s"){

        @Override
        public LocalDateTime addTime(LocalDateTime now, long value) {
            return now.plusSeconds(value);
        }
    }
    ,
    MINUTE("m"){

        @Override
        public LocalDateTime addTime(LocalDateTime now, long value) {
            return now.plusMinutes(value);
        }
    }
    ,
    HOUR("h"){

        @Override
        public LocalDateTime addTime(LocalDateTime now, long value) {
            return now.plusHours(value);
        }
    }
    ,
    DAY("d"){

        @Override
        public LocalDateTime addTime(LocalDateTime now, long value) {
            return now.plusDays(value);
        }
    }
    ,
    MONTH("mo"){

        @Override
        public LocalDateTime addTime(LocalDateTime now, long value) {
            return now.plusMonths(value);
        }
    }
    ,
    YEAR("y"){

        @Override
        public LocalDateTime addTime(LocalDateTime now, long value) {
            return now.plusYears(value);
        }
    };

    private final String suffix;

    private TimeUnit(String suffix) {
        this.suffix = suffix;
    }

    public static TimeUnit fromSuffix(String suffix) throws ParseException {
        for (TimeUnit unit : TimeUnit.values()) {
            if (!unit.getSuffix().equals(suffix)) continue;
            return unit;
        }
        throw new ParseException("Unsupported time unit: " + suffix);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public abstract LocalDateTime addTime(LocalDateTime var1, long var2);
}

