/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.bukkit;

import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import one.tranic.t.base.TBase;
import one.tranic.t.base.command.source.SystemCommandSource;
import one.tranic.t.base.player.Players;
import one.tranic.t.bukkit.command.source.BukkitConsoleSource;
import one.tranic.t.bukkit.player.BukkitPlayers;
import one.tranic.t.utils.Reflect;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class TBukkit {
    private static boolean initialized = false;
    private static BukkitAudiences adventure;

    @NotNull
    public static BukkitAudiences adventure() {
        if (adventure == null) {
            throw new IllegalStateException("Tried to access Adventure when the plugin was disabled!");
        }
        return adventure;
    }

    public static void init(Plugin plugin) {
        if (initialized) {
            return;
        }
        adventure = BukkitAudiences.create((Plugin)plugin);
        try {
            Reflect.assignToStaticFieldIfUninitialized(TBase.class, (String)"getConsoleSourceSupplier", TBukkit::getBukkitConsoleSource, (boolean)false);
            Reflect.assignToStaticFieldIfUninitialized(Players.class, (String)"getPlayerWithStringMethod", BukkitPlayers::getPlayer, (boolean)false);
            Reflect.assignToStaticFieldIfUninitialized(Players.class, (String)"getPlayerWithUUIDMethod", BukkitPlayers::getPlayer, (boolean)false);
            Reflect.assignToStaticFieldIfUninitialized(Players.class, (String)"getOnlinePlayersMethod", BukkitPlayers::getOnlinePlayers, (boolean)false);
            Reflect.assignToStaticFieldIfUninitialized(Players.class, (String)"getPlatformOnlinePlayersMethod", BukkitPlayers::getPlatformOnlinePlayers, (boolean)false);
            Reflect.assignToStaticFieldIfUninitialized(Players.class, (String)"getOnlinePlayersNameMethod", BukkitPlayers::getOnlinePlayersName, (boolean)false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        initialized = true;
    }

    public static void disable() {
        if (adventure != null) {
            adventure.close();
            adventure = null;
        }
        initialized = false;
    }

    public static SystemCommandSource<?, ?> getBukkitConsoleSource() {
        return new BukkitConsoleSource();
    }
}

