/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.bukkit.player;

import java.net.InetSocketAddress;
import java.util.Locale;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import one.tranic.t.base.message.Message;
import one.tranic.t.base.player.BedrockPlayer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitPlayer
implements one.tranic.t.base.player.Player<Player> {
    private final Player player;

    public BukkitPlayer(Player player) {
        this.player = player;
    }

    public BukkitPlayer(CommandSender commandSender) {
        this.player = (Player)commandSender;
    }

    @Nullable
    public static BukkitPlayer createPlayer(@Nullable Player player) {
        if (player == null) {
            return null;
        }
        return new BukkitPlayer(player);
    }

    @Nullable
    public static BukkitPlayer createPlayer(@NotNull UUID uuid) {
        Player p = Bukkit.getPlayer((UUID)uuid);
        return BukkitPlayer.createPlayer(p);
    }

    @Nullable
    public static BukkitPlayer createPlayer(@NotNull String username) {
        Player p = Bukkit.getPlayer((String)username);
        return BukkitPlayer.createPlayer(p);
    }

    @NotNull
    public String getUsername() {
        return this.player.getName();
    }

    @NotNull
    public UUID getUniqueId() {
        return this.player.getUniqueId();
    }

    @NotNull
    public String getConnectedHost() {
        @Nullable InetSocketAddress addr = this.player.getAddress();
        if (addr == null) {
            return "127.0.0.1";
        }
        return addr.getAddress().getHostAddress();
    }

    @NotNull
    public Locale getLocale() {
        return Locale.forLanguageTag(this.player.getLocale());
    }

    @Nullable
    public one.tranic.t.base.player.Location getLocation() {
        Location l = this.player.getLocation();
        return new one.tranic.t.base.player.Location(l.getWorld().getName(), l.getX(), l.getY(), l.getZ(), l.getYaw(), l.getPitch());
    }

    public long getPing() {
        long ping;
        if (this.isBedrockPlayer() && (ping = BedrockPlayer.getPing((UUID)this.getUniqueId())) != -1L) {
            return ping;
        }
        return this.player.getPing();
    }

    public boolean isOnline() {
        return this.player.isOnline();
    }

    @Nullable
    public String getClientBrand() {
        if (this.isBedrockPlayer()) {
            return BedrockPlayer.getPlatform((UUID)this.getUniqueId());
        }
        return "Java Edition";
    }

    public Player getSourcePlayer() {
        return this.player;
    }

    public boolean kick() {
        this.player.kickPlayer("Losing connection to server");
        return true;
    }

    public boolean kick(String reason) {
        return this.kick((Component)Component.text((String)reason));
    }

    public boolean kick(@NotNull Component reason) {
        this.player.kickPlayer(Message.toString((Component)reason));
        return true;
    }

    public void sendMessage(@NotNull String message) {
        this.player.sendMessage(message);
    }

    public void sendMessage(@NotNull Component message) {
        this.player.sendMessage(Message.toString((Component)message));
    }
}

