/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.bukkit.command.source;

import java.util.Locale;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.title.Title;
import one.tranic.t.base.TBase;
import one.tranic.t.base.command.Operator;
import one.tranic.t.base.command.source.CommandSource;
import one.tranic.t.bukkit.TBukkit;
import one.tranic.t.bukkit.player.BukkitPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitSource
implements CommandSource<CommandSender, Player> {
    private final CommandSender commandSender;
    private final String[] args;
    private final BukkitPlayer player;

    public BukkitSource(CommandSender commandSender, String[] args) {
        this.commandSender = commandSender;
        this.args = args;
        this.player = commandSender instanceof Player ? new BukkitPlayer(commandSender) : null;
    }

    public Operator getOperator() {
        if (this.player != null) {
            return new Operator(this.player.getUsername(), this.player.getUniqueId());
        }
        return TBase.console();
    }

    public CommandSender getSource() {
        return this.commandSender;
    }

    public boolean isPlayer() {
        return this.player != null;
    }

    public String[] getArgs() {
        return this.args;
    }

    public int argSize() {
        return this.args.length;
    }

    @Nullable
    public Locale getLocale() {
        return this.player != null ? this.player.getLocale() : Locale.getDefault();
    }

    public boolean hasPermission(String permission) {
        return this.commandSender.hasPermission(permission);
    }

    public void sendMessage(String message) {
        this.commandSender.sendMessage(message);
    }

    public void sendMessage(@NotNull Component message) {
        this.commandSender.sendMessage(LegacyComponentSerializer.legacySection().serialize(message));
    }

    public void showBossBar(@NotNull BossBar bossBar) {
        if (this.isPlayer()) {
            TBukkit.adventure().player(this.player.getSourcePlayer()).showBossBar(bossBar);
        }
    }

    public void hideBossBar(@NotNull BossBar bossBar) {
        if (this.isPlayer()) {
            TBukkit.adventure().player(this.player.getSourcePlayer()).hideBossBar(bossBar);
        }
    }

    public void clearBossBars() {
    }

    public void showTitle(@NotNull Title title) {
        if (this.isPlayer()) {
            TBukkit.adventure().player(this.player.getSourcePlayer()).showTitle(title);
        }
    }

    public void clearTitle() {
        if (this.isPlayer()) {
            TBukkit.adventure().player(this.player.getSourcePlayer()).clearTitle();
        }
    }

    @Nullable
    public BukkitPlayer asPlayer() {
        return this.player;
    }
}

