/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.i18n;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.yaml.snakeyaml.Yaml;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum I18n {
    SnakeYAML{
        private final ResourceLoader resourceLoader = new ResourceLoader(){

            @Override
            protected String getFileExtension() {
                return ".yml";
            }

            @Override
            protected String getAlternativeFileExtension() {
                return ".yaml";
            }

            @Override
            protected Map<String, String> parseInputStream(InputStream inputStream) throws IOException {
                Yaml yaml = new Yaml();
                Map yamlMap = (Map)yaml.load(inputStream);
                HashMap<String, String> result = new HashMap<String, String>();
                I18n.flattenYaml(yamlMap, "", result);
                return result;
            }

            @Override
            protected String getFormatName() {
                return "YAML";
            }
        };

        @Override
        @NotNull
        Map<String, String> load(Class<?> clazz, String namespace, Locale locale) throws IOException {
            return this.resourceLoader.load(clazz, namespace, locale);
        }
    }
    ,
    GSON{
        private final Gson gson = new Gson();
        private final ResourceLoader resourceLoader = new ResourceLoader(){

            @Override
            protected String getFileExtension() {
                return ".json";
            }

            @Override
            protected Map<String, String> parseInputStream(InputStream inputStream) throws IOException {
                InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                TypeToken<Map<String, String>> typeToken = new TypeToken<Map<String, String>>(){};
                Map jsonMap = (Map)gson.fromJson((Reader)reader, typeToken.getType());
                HashMap<String, String> result = new HashMap<String, String>();
                if (jsonMap != null) {
                    result.putAll(jsonMap);
                }
                return result;
            }

            @Override
            protected String getFormatName() {
                return "JSON";
            }
        };

        @Override
        @NotNull
        Map<String, String> load(Class<?> clazz, String namespace, Locale locale) throws IOException {
            return this.resourceLoader.load(clazz, namespace, locale);
        }
    }
    ,
    PROPERTIES{
        private final ResourceLoader resourceLoader = new ResourceLoader(){

            @Override
            protected String getFileExtension() {
                return ".properties";
            }

            @Override
            protected Map<String, String> parseInputStream(InputStream inputStream) throws IOException {
                Properties properties = new Properties();
                properties.load(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                HashMap<String, String> result = new HashMap<String, String>();
                for (String key : properties.stringPropertyNames()) {
                    result.put(key, properties.getProperty(key));
                }
                return result;
            }

            @Override
            protected String getFormatName() {
                return "Properties";
            }
        };

        @Override
        @NotNull
        Map<String, String> load(Class<?> clazz, String namespace, Locale locale) throws IOException {
            return this.resourceLoader.load(clazz, namespace, locale);
        }
    }
    ,
    XML{
        private final ResourceLoader resourceLoader = new ResourceLoader(){
            private final String[] ignoredTags = new String[]{"messages", "resources", "strings", "message"};

            @Override
            protected String getFileExtension() {
                return ".xml";
            }

            @Override
            protected Map<String, String> parseInputStream(InputStream inputStream) throws IOException {
                HashMap<String, String> result = new HashMap<String, String>();
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.parse(inputStream);
                    Element root = document.getDocumentElement();
                    NodeList children = root.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        Node node = children.item(i);
                        if (!(node instanceof Element)) continue;
                        Element child = (Element)node;
                        this.processXmlElement(child, "", result);
                    }
                    return result;
                }
                catch (Exception e) {
                    throw new IOException("Failed to parse XML file: " + e.getMessage(), e);
                }
            }

            private void processXmlElement(Element element, String prefix, Map<String, String> result) {
                if (element.hasAttribute("id") && element.getTextContent() != null && !element.getTextContent().trim().isEmpty()) {
                    String key = element.getAttribute("id");
                    result.put(key, element.getTextContent().trim());
                    return;
                }
                String nodeName = element.getNodeName();
                String newPrefix = this.getNewPrefix(prefix, nodeName);
                NodeList childElements = element.getElementsByTagName("*");
                boolean hasElementChildren = false;
                for (int i = 0; i < childElements.getLength(); ++i) {
                    if (childElements.item(i).getParentNode() != element) continue;
                    hasElementChildren = true;
                    break;
                }
                if (!(hasElementChildren || element.getTextContent() == null || element.getTextContent().trim().isEmpty() || nodeName.equals("messages") || nodeName.equals("resources") || nodeName.equals("strings"))) {
                    result.put(newPrefix, element.getTextContent().trim());
                }
                NodeList children = element.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    if (!(children.item(i) instanceof Element)) continue;
                    this.processXmlElement((Element)children.item(i), newPrefix, result);
                }
            }

            private String getNewPrefix(String prefix, String nodeName) {
                boolean isSpecialTag = false;
                for (int i = 0; i < this.ignoredTags.length; ++i) {
                    if (!this.ignoredTags[i].equals(nodeName)) continue;
                    isSpecialTag = true;
                    break;
                }
                Object newPrefix = isSpecialTag ? prefix : (prefix.isEmpty() ? nodeName : prefix + "." + nodeName);
                return newPrefix;
            }

            @Override
            protected String getFormatName() {
                return "XML";
            }
        };

        @Override
        @NotNull
        Map<String, String> load(Class<?> clazz, String namespace, Locale locale) throws IOException {
            return this.resourceLoader.load(clazz, namespace, locale);
        }
    };


    private static void flattenYaml(Map<String, Object> yamlMap, String prefix, Map<String, String> result) {
        if (yamlMap == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : yamlMap.entrySet()) {
            String key = prefix.isEmpty() ? entry.getKey() : prefix + "." + entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                I18n.flattenYaml((Map)value, key, result);
                continue;
            }
            if (value == null) continue;
            result.put(key, value.toString());
        }
    }

    @NotNull
    private static String getBasePath(@Nullable String namespace, @NotNull Locale locale) {
        return namespace != null ? namespace + "/" + locale : locale.toString();
    }

    private static InputStream getResource(Class<?> clazz, @NotNull String filename) {
        try {
            URL url = clazz.getClassLoader().getResource(filename);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException ex) {
            return null;
        }
    }

    @NotNull
    abstract Map<String, String> load(Class<?> var1, String var2, Locale var3) throws IOException;

    private static abstract class ResourceLoader {
        private ResourceLoader() {
        }

        protected abstract String getFileExtension();

        protected String getAlternativeFileExtension() {
            return null;
        }

        protected abstract String getFormatName();

        protected abstract Map<String, String> parseInputStream(InputStream var1) throws IOException;

        public Map<String, String> load(Class<?> clazz, String namespace, Locale locale) throws IOException {
            String basePath = I18n.getBasePath(namespace, locale);
            InputStream inputStream = I18n.getResource(clazz, basePath + this.getFileExtension());
            String alternativeExt = this.getAlternativeFileExtension();
            if (inputStream == null && alternativeExt != null) {
                inputStream = I18n.getResource(clazz, basePath + alternativeExt);
            }
            if (inputStream == null) {
                throw new IOException("Failed to load " + this.getFormatName() + " file for " + clazz.getName() + " in " + locale);
            }
            try (InputStream is = inputStream;){
                Map<String, String> map = this.parseInputStream(is);
                return map;
            }
        }
    }
}

