/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.i18n;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import one.tranic.t.i18n.I18n;
import org.jetbrains.annotations.NotNull;

public class I18nLoader {
    private final Map<String, String> language;
    private final String namespace;
    private final Class<?> clazz;
    Locale locale;
    I18n adaptar;

    public I18nLoader(@Nullable Class<?> clazz, @NotNull String namespace) {
        this(clazz, namespace, Locale.ENGLISH);
    }

    public I18nLoader(@Nullable Class<?> clazz, @NotNull String namespace, @NotNull Locale locale) {
        this.clazz = clazz != null ? clazz : I18nLoader.class;
        this.locale = locale;
        this.namespace = namespace;
        this.language = new HashMap<String, String>();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("I18nLoader{");
        int size = this.language.size();
        if (size < 15) {
            sb.append("language=").append(this.language).append(", ");
        }
        sb.append("languageSize=").append(size).append(", namespace='").append(this.namespace).append('\'').append(", clazz=").append(this.clazz).append(", locale=").append(this.locale.getLanguage()).append(", adaptar=").append((Object)this.adaptar).append('}');
        return sb.toString();
    }

    public void reset(@Nullable Locale locale) {
        if (this.language != null) {
            this.language.clear();
        }
        this.locale = locale;
    }

    public void setLanguage(@NotNull Locale locale) {
        this.locale = locale;
    }

    public void setAdaptar(@NotNull I18n adaptar) {
        this.adaptar = adaptar;
    }

    public void update() throws IOException {
        Map<String, String> lang = this.adaptar.load(this.clazz, this.namespace, this.locale);
        this.language.clear();
        this.language.putAll(lang);
    }

    @NotNull
    public String to(@NotNull String key) {
        return this.language.getOrDefault(key, key);
    }

    @NotNull
    public String to(@NotNull String key, Object ... args) {
        return String.format(this.to(key), args);
    }

    @NotNull
    public String toBrace(@NotNull String key, Object ... args) {
        String text = this.to(key);
        if (args.length == 0 || key.equals(text)) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text);
        String placeholder = "{}";
        int searchFrom = 0;
        for (int placeholderIndex = 0; (searchFrom = sb.indexOf(placeholder, searchFrom)) != -1 && placeholderIndex < args.length; ++placeholderIndex) {
            sb.replace(searchFrom, searchFrom + placeholder.length(), String.valueOf(args[placeholderIndex]));
            searchFrom += String.valueOf(args[placeholderIndex]).length();
        }
        return sb.toString();
    }

    @NotNull
    public BaseComponent[] toBaseComponent(@NotNull String key) {
        return TextComponent.fromLegacyText((String)this.to(key));
    }

    @NotNull
    public BaseComponent[] toBaseComponent(@NotNull String key, Object ... args) {
        return TextComponent.fromLegacyText((String)this.to(key, args));
    }

    @NotNull
    public BaseComponent[] toBaseComponentBrace(@NotNull String key, Object ... args) {
        return TextComponent.fromLegacyText((String)this.toBrace(key, args));
    }

    @NotNull
    public Component toComponent(@NotNull String key) {
        return Component.text((String)this.to(key));
    }

    @NotNull
    public Component toComponent(@NotNull String key, Object ... args) {
        return Component.text((String)this.to(key, args));
    }

    @NotNull
    public Component toComponentBrace(@NotNull String key, Object ... args) {
        return Component.text((String)this.toBrace(key, args));
    }

    @NotNull
    public Component toComponent(@NotNull String key, TagResolver ... tagResolvers) {
        String text = this.to(key);
        if (!text.equals(key)) {
            return MiniMessage.miniMessage().deserialize(text, tagResolvers);
        }
        return Component.text((String)key);
    }
}

