/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.i18n;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import one.tranic.t.i18n.I18n;
import one.tranic.t.utils.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class I18nLoader {
    private static final boolean v1;
    @NotNull
    private final Map<String, String> language;
    @Nullable
    private final String namespace;
    @Nullable
    private final Path path;
    @Nullable
    private final File file;
    @NotNull
    private final I18n adaptar;
    @Nullable
    private final Class<?> clazz;
    @Nullable
    private Locale locale;

    public I18nLoader(@NotNull File file, @NotNull I18n adaptar) {
        this(file, null, null, null, null, adaptar);
    }

    public I18nLoader(@NotNull String namespace, @NotNull I18n adaptar) throws IllegalArgumentException {
        this(null, null, null, namespace, null, adaptar);
    }

    public I18nLoader(@NotNull Path path, @NotNull I18n adaptar) throws IllegalArgumentException {
        this(null, path, null, null, null, adaptar);
    }

    public I18nLoader(@NotNull Class<?> clazz, @NotNull String namespace, @NotNull I18n adaptar) throws IllegalArgumentException {
        this(null, null, clazz, namespace, Locale.ENGLISH, adaptar);
    }

    public I18nLoader(@NotNull Class<?> clazz, @NotNull String namespace, @NotNull Locale locale, @NotNull I18n adaptar) throws IllegalArgumentException {
        this(null, null, clazz, namespace, locale, adaptar);
    }

    public I18nLoader(@Nullable File file, @Nullable Path path, @Nullable Class<?> clazz, @Nullable String namespace, @Nullable Locale locale, @NotNull I18n adaptar) throws IllegalArgumentException {
        this.file = file;
        this.clazz = file == null ? clazz : null;
        this.locale = locale == null ? Locale.ENGLISH : locale;
        this.namespace = namespace;
        if (this.clazz != null && this.namespace == null) {
            throw new IllegalArgumentException("Namespace must not be null when loading from a class");
        }
        if (this.clazz == null && this.namespace != null) {
            this.path = Path.of(this.namespace, new String[0]);
            if (!Files.exists(this.path, new LinkOption[0])) {
                throw new IllegalArgumentException("Namespace does not exist: " + this.namespace);
            }
        } else {
            this.path = path;
        }
        this.language = I18nLoader.createMap();
        this.adaptar = adaptar;
    }

    public static <K, V> Map<K, V> createMap() {
        return v1 ? Collections.newHashMap() : new HashMap();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("I18nLoader{");
        int size = this.language.size();
        if (size < 15) {
            sb.append("language=").append(this.language).append(", ");
        }
        sb.append("languageSize=").append(size);
        if (this.namespace != null) {
            sb.append(", namespace='").append(this.namespace).append('\'');
        }
        if (this.clazz != null) {
            sb.append(", class=").append(this.clazz);
        }
        if (this.file != null) {
            sb.append(", file='").append(this.file).append('\'');
        }
        if (this.locale != null) {
            sb.append(", locale=").append(this.locale.getLanguage());
        }
        sb.append(", adaptar=").append((Object)this.adaptar).append('}');
        return sb.toString();
    }

    public int hashCode() {
        int result = this.language.hashCode();
        result = 31 * result + (this.namespace != null && !this.namespace.isBlank() ? this.namespace.hashCode() : 0);
        result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
        result = 31 * result + (this.clazz != null ? this.clazz.hashCode() : 0);
        result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
        result = 31 * result + this.adaptar.hashCode();
        return result;
    }

    public void reset(@Nullable Locale locale) {
        this.language.clear();
        this.locale = locale;
    }

    public void reset() {
        this.reset(this.locale);
    }

    public void update() throws IOException {
        this.update(this.locale);
    }

    public void update(@NotNull Locale locale) throws IOException {
        Map<String, String> lang;
        this.locale = locale;
        if (this.file != null) {
            lang = this.adaptar.load(this.file);
        } else if (this.path != null) {
            lang = this.adaptar.load(this.path, locale);
        } else if (this.clazz != null && this.namespace != null) {
            lang = this.adaptar.load(this.clazz, this.namespace, locale);
        } else {
            throw new IOException("Invalid configuration for loading language map");
        }
        this.language.clear();
        this.language.putAll(lang);
    }

    public void update(@NotNull InputStream customInputStream) throws IOException {
        Map<String, String> lang = this.adaptar.load(customInputStream);
        this.language.clear();
        this.language.putAll(lang);
    }

    @NotNull
    public Map<String, String> getLanguageMap() {
        return v1 ? Collections.newHashMap(this.language) : new HashMap<String, String>(this.language);
    }

    @Nullable
    public Locale getLanguage() {
        return this.locale;
    }

    public void setLanguage(@NotNull Locale locale) {
        this.locale = locale;
    }

    @NotNull
    public String to(@NotNull String key) {
        return this.language.getOrDefault(key, key);
    }

    @NotNull
    public String to(@NotNull String key, Object ... args) {
        String text = this.to(key);
        if (args.length == 0 || key.equals(text)) {
            return text;
        }
        return String.format(text, args);
    }

    @NotNull
    public String toBrace(@NotNull String key, Object ... args) {
        String text = this.to(key);
        if (args.length == 0 || key.equals(text)) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text);
        String placeholder = "{}";
        int searchFrom = 0;
        for (int placeholderIndex = 0; (searchFrom = sb.indexOf(placeholder, searchFrom)) != -1 && placeholderIndex < args.length; ++placeholderIndex) {
            sb.replace(searchFrom, searchFrom + placeholder.length(), String.valueOf(args[placeholderIndex]));
            searchFrom += String.valueOf(args[placeholderIndex]).length();
        }
        return sb.toString();
    }

    @NotNull
    public String toBrace(@NotNull String key, SimpleComponent ... args) {
        String text = this.to(key);
        if (args.length == 0 || key.equals(text)) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text);
        for (SimpleComponent component : args) {
            int placeholderIndex;
            String placeholder = "{" + component.keyword() + "}";
            while ((placeholderIndex = sb.indexOf(placeholder)) != -1) {
                sb.replace(placeholderIndex, placeholderIndex + placeholder.length(), String.valueOf(component.value()));
            }
        }
        return sb.toString();
    }

    @NotNull
    public BaseComponent[] toBaseComponent(@NotNull String key) {
        return TextComponent.fromLegacyText((String)this.to(key));
    }

    @NotNull
    public BaseComponent[] toBaseComponent(@NotNull String key, Object ... args) {
        return TextComponent.fromLegacyText((String)this.to(key, args));
    }

    @NotNull
    public BaseComponent[] toBaseComponentBrace(@NotNull String key, Object ... args) {
        return TextComponent.fromLegacyText((String)this.toBrace(key, args));
    }

    @NotNull
    public BaseComponent[] toBaseComponentBrace(@NotNull String key, SimpleComponent ... args) {
        return TextComponent.fromLegacyText((String)this.toBrace(key, args));
    }

    @NotNull
    public Component toComponent(@NotNull String key) {
        return Component.text((String)this.to(key));
    }

    @NotNull
    public Component toComponent(@NotNull String key, Object ... args) {
        return Component.text((String)this.to(key, args));
    }

    @NotNull
    public Component toComponentBrace(@NotNull String key, Object ... args) {
        return Component.text((String)this.toBrace(key, args));
    }

    @NotNull
    public Component toComponentBrace(@NotNull String key, SimpleComponent ... args) {
        return Component.text((String)this.toBrace(key, args));
    }

    @NotNull
    public Component toComponent(@NotNull String key, TagResolver ... tagResolvers) {
        String text = this.to(key);
        if (!text.equals(key)) {
            return MiniMessage.miniMessage().deserialize(text, tagResolvers);
        }
        return Component.text((String)key);
    }

    static {
        boolean v2 = false;
        try {
            Class.forName("one.tranic.t.utils.Collections");
            v2 = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        v1 = v2;
    }

    public record SimpleComponent(@NotNull String keyword, @NotNull Object value) {
    }
}

