/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.paper;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import one.tranic.t.base.TInterface;
import one.tranic.t.base.command.source.SystemCommandSource;
import one.tranic.t.bukkit.player.BukkitPlayer;
import one.tranic.t.paper.command.source.PaperConsoleSource;
import one.tranic.t.paper.player.PaperPlayer;
import one.tranic.t.utils.Collections;
import one.tranic.t.utils.minecraft.Platform;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TPaper
implements TInterface<CommandSender, Player> {
    private static boolean initialized = false;
    private final Plugin plugin;
    private final Platform[] supportedPlatforms = new Platform[]{Platform.Paper, Platform.ShreddedPaper, Platform.Folia};

    public TPaper(Plugin plugin) {
        this.plugin = plugin;
        this.enable();
    }

    public void disable() {
        initialized = false;
    }

    public void enable() {
        if (initialized) {
            return;
        }
        initialized = true;
    }

    public Platform[] getSupportedPlatforms() {
        return this.supportedPlatforms;
    }

    @Nullable
    public one.tranic.t.base.player.Player<Player> getPlayer(@NotNull String name) {
        return PaperPlayer.createPlayer(name);
    }

    @Nullable
    public one.tranic.t.base.player.Player<Player> getPlayer(@NotNull UUID uuid) {
        return PaperPlayer.createPlayer(uuid);
    }

    @NotNull
    public List<one.tranic.t.base.player.Player<Player>> getOnlinePlayers() {
        List players = Collections.newArrayList();
        for (Player p : Bukkit.getOnlinePlayers()) {
            players.add(BukkitPlayer.createPlayer((Player)p));
        }
        return players;
    }

    @NotNull
    public List<Player> getPlatformOnlinePlayers() {
        return Collections.newArrayList((Collection)Bukkit.getOnlinePlayers());
    }

    @NotNull
    public List<String> getOnlinePlayersName() {
        List players = Collections.newArrayList();
        for (Player p : Bukkit.getOnlinePlayers()) {
            players.add(p.getName());
        }
        return players;
    }

    public SystemCommandSource<CommandSender, Player> getConsoleSource() {
        return new PaperConsoleSource();
    }
}

