/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class Reflect {
    public static void assignToStaticFieldIfUninitialized(Class<?> targetClass, String fieldName, Object value, boolean debug) throws NoSuchFieldException, IllegalAccessException {
        Field field = targetClass.getDeclaredField(fieldName);
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("Field " + fieldName + " is not static.");
        }
        field.setAccessible(true);
        if (field.get(null) != null) {
            return;
        }
        field.set(null, value);
    }

    public static boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

