/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.utils;

import one.tranic.t.utils.Reflect;
import org.jetbrains.annotations.NotNull;

public enum Platform {
    Velocity("com.velocitypowered.api.proxy.Proxy"),
    BungeeCord("net.md_5.bungee.api.CommandSender"),
    Spigot("org.bukkit.Bukkit"),
    Paper("io.papermc.paper.util.MCUtil"),
    ShreddedPaper("io.multipaper.shreddedpaper.threading.ShreddedPaperTickThread"),
    Folia("io.papermc.paper.threadedregions.commands.CommandServerHealth");

    private static Platform platform;
    private final String classPath;

    private Platform(String classPath) {
        this.classPath = classPath;
    }

    @NotNull
    public static Platform get() {
        if (platform != null) {
            return platform;
        }
        if (Velocity.is()) {
            platform = Velocity;
            return platform;
        }
        if (BungeeCord.is()) {
            platform = BungeeCord;
            return platform;
        }
        if (Folia.is()) {
            platform = Folia;
            return platform;
        }
        if (ShreddedPaper.is()) {
            platform = ShreddedPaper;
            return platform;
        }
        if (Paper.is()) {
            platform = Paper;
            return platform;
        }
        platform = Spigot;
        return Spigot;
    }

    @NotNull
    public static Platform of(@NotNull String name) {
        return switch (name.toLowerCase()) {
            case "velocity" -> Velocity;
            case "bungeecord" -> BungeeCord;
            case "spigot" -> Spigot;
            case "paper" -> Paper;
            case "shreddedpaper" -> ShreddedPaper;
            case "folia" -> Folia;
            default -> throw new IllegalArgumentException("Unknown platform: " + name);
        };
    }

    public static boolean isBukkit() {
        return Platform.get() == Spigot || Platform.get() == Paper || Platform.get() == Folia || Platform.get() == ShreddedPaper;
    }

    public static boolean isMultithreading() {
        return Platform.get() == Folia || Platform.get() == ShreddedPaper;
    }

    @NotNull
    public String toString() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case Velocity -> "velocity";
            case BungeeCord -> "bungeecord";
            case Spigot -> "spigot";
            case Paper -> "paper";
            case ShreddedPaper -> "shreddedpaper";
            case Folia -> "folia";
        };
    }

    @NotNull
    public String toRawString() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case Velocity -> "Velocity";
            case BungeeCord -> "BungeeCord";
            case Spigot -> "Spigot";
            case Paper -> "Paper";
            case ShreddedPaper -> "ShreddedPaper";
            case Folia -> "Folia";
        };
    }

    public String getClassPath() {
        return this.classPath;
    }

    public boolean is() {
        return Reflect.hasClass(this.classPath);
    }
}

