/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.utils;

import one.tranic.t.utils.Reflect;
import org.jetbrains.annotations.NotNull;

public enum Platform {
    Velocity("Velocity", "com.velocitypowered.api.proxy.ProxyServer"),
    BungeeCord("BungeeCord", "net.md_5.bungee.api.CommandSender"),
    Spigot("Spigot", "org.bukkit.Bukkit"),
    Paper("Paper", "io.papermc.paper.util.MCUtil"),
    ShreddedPaper("ShreddedPaper", "io.multipaper.shreddedpaper.threading.ShreddedPaperTickThread"),
    Folia("Folia", "io.papermc.paper.threadedregions.commands.CommandServerHealth");

    private static Platform platform;
    private final String name;
    private final String[] classPath;

    private Platform(String name, String ... classPath) {
        this.name = name;
        this.classPath = classPath;
    }

    @NotNull
    public static Platform get() {
        if (platform != null) {
            return platform;
        }
        if (Velocity.is()) {
            platform = Velocity;
            return platform;
        }
        if (BungeeCord.is()) {
            platform = BungeeCord;
            return platform;
        }
        if (Folia.is()) {
            platform = Folia;
            return platform;
        }
        if (ShreddedPaper.is()) {
            platform = ShreddedPaper;
            return platform;
        }
        if (Paper.is()) {
            platform = Paper;
            return platform;
        }
        platform = Spigot;
        return Spigot;
    }

    @NotNull
    public static Platform of(@NotNull String name) {
        String n1 = name.toLowerCase();
        for (Platform p : Platform.values()) {
            if (!p.name.toLowerCase().equals(n1)) continue;
            return p;
        }
        throw new IllegalArgumentException("Unknown platform: " + name);
    }

    public static boolean isBukkit() {
        return Platform.get() == Spigot || Platform.get() == Paper || Platform.get() == Folia || Platform.get() == ShreddedPaper;
    }

    public static boolean isMultithreading() {
        return Platform.get() == Folia || Platform.get() == ShreddedPaper;
    }

    @NotNull
    public String toString() {
        return this.name.toLowerCase();
    }

    @NotNull
    public String toRawString() {
        return this.name;
    }

    public String[] getClassPath() {
        return this.classPath;
    }

    public boolean is() {
        if (this.classPath.length == 1) {
            return Reflect.hasClass(this.classPath[0]);
        }
        for (String classPath : this.classPath) {
            if (!Reflect.hasClass(classPath)) continue;
            return true;
        }
        return false;
    }
}

