/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Reflect {
    public static void assignToStaticFieldIfUninitialized(@NotNull Class<?> targetClass, @NotNull String fieldName, @NotNull Object value) throws NoSuchFieldException, IllegalAccessException {
        Field field = targetClass.getDeclaredField(fieldName);
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("Field " + fieldName + " is not static.");
        }
        field.setAccessible(true);
        if (field.get(null) != null) {
            return;
        }
        field.set(null, value);
    }

    public static boolean hasClass(@NotNull String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Nullable
    public static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

