/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.logging.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class SimplePatcher {
    private static final int CHUNK_SIZE = 4096;
    private static final byte COMMAND_EQUAL = 0;
    private static final byte COMMAND_INSERT = 1;
    private static final byte COMMAND_DELETE = 2;

    public static OutputStream createPatch(InputStream src, InputStream dst) throws IOException {
        ByteArrayOutputStream patchOutputStream = new ByteArrayOutputStream();
        DataOutputStream patch = new DataOutputStream(patchOutputStream);
        byte[] srcData = SimplePatcher.readAllBytes(src);
        byte[] dstData = SimplePatcher.readAllBytes(dst);
        patch.writeInt(srcData.length);
        patch.writeInt(dstData.length);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] srcHash = md.digest(srcData);
            patch.write(srcHash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Failed to calculate MD5 checksum", e);
        }
        int i = 0;
        int j = 0;
        while (i < srcData.length || j < dstData.length) {
            int matchLength = 0;
            while (i + matchLength < srcData.length && j + matchLength < dstData.length && srcData[i + matchLength] == dstData[j + matchLength]) {
                ++matchLength;
            }
            if (matchLength > 0) {
                patch.writeByte(0);
                patch.writeInt(matchLength);
                i += matchLength;
                j += matchLength;
                continue;
            }
            int srcDiffStart = i;
            int dstDiffStart = j;
            do {
                int lookAhead;
                boolean foundMatch = false;
                for (lookAhead = 1; lookAhead < 32 && i + lookAhead < srcData.length && j < dstData.length; ++lookAhead) {
                    if (srcData[i + lookAhead] != dstData[j]) continue;
                    i += lookAhead;
                    foundMatch = true;
                    break;
                }
                if (foundMatch) break;
                for (lookAhead = 1; lookAhead < 32 && i < srcData.length && j + lookAhead < dstData.length; ++lookAhead) {
                    if (srcData[i] != dstData[j + lookAhead]) continue;
                    j += lookAhead;
                    foundMatch = true;
                    break;
                }
                if (foundMatch) break;
                if (i < srcData.length) {
                    ++i;
                }
                if (j >= dstData.length) continue;
                ++j;
            } while (i < srcData.length || j < dstData.length);
            if (i > srcDiffStart) {
                patch.writeByte(1);
                patch.writeInt(i - srcDiffStart);
                patch.write(srcData, srcDiffStart, i - srcDiffStart);
            }
            if (j <= dstDiffStart) continue;
            patch.writeByte(2);
            patch.writeInt(j - dstDiffStart);
            patch.write(dstData, dstDiffStart, j - dstDiffStart);
        }
        patch.flush();
        return patchOutputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OutputStream applyPatch(InputStream patch, InputStream dst) throws IOException {
        DataInputStream patchInput = new DataInputStream(patch);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] dstData = SimplePatcher.readAllBytes(dst);
        int originalSrcSize = patchInput.readInt();
        int originalDstSize = patchInput.readInt();
        if (dstData.length != originalDstSize) {
            throw new IllegalStateException("Patch not applicable to target file: size mismatch, expected " + originalDstSize + ", actual " + dstData.length);
        }
        byte[] expectedMD5 = new byte[16];
        patchInput.readFully(expectedMD5);
        int dstPos = 0;
        try {
            block7: while (patchInput.available() > 0) {
                byte command = patchInput.readByte();
                switch (command) {
                    case 0: {
                        int equalLength = patchInput.readInt();
                        if (dstPos + equalLength > dstData.length) {
                            throw new IllegalStateException("Patch application failed: exceeded target file boundary");
                        }
                        output.write(dstData, dstPos, equalLength);
                        dstPos += equalLength;
                        continue block7;
                    }
                    case 1: {
                        int insertLength = patchInput.readInt();
                        byte[] insertData = new byte[insertLength];
                        patchInput.readFully(insertData);
                        output.write(insertData);
                        continue block7;
                    }
                    case 2: {
                        int deleteLength = patchInput.readInt();
                        byte[] expectedDeleteData = new byte[deleteLength];
                        patchInput.readFully(expectedDeleteData);
                        if (dstPos + deleteLength > dstData.length) {
                            throw new IllegalStateException("Patch application failed: exceeded target file boundary");
                        }
                        byte[] actualDeleteData = Arrays.copyOfRange(dstData, dstPos, dstPos + deleteLength);
                        if (!Arrays.equals(expectedDeleteData, actualDeleteData)) {
                            throw new IllegalStateException("Patch application failed: target file content mismatch, cannot apply patch");
                        }
                        dstPos += deleteLength;
                        continue block7;
                    }
                }
                throw new IllegalStateException("Patch file format error: unknown command code " + command);
            }
            if (dstPos != dstData.length) {
                throw new IllegalStateException("Patch application failed: target file not fully processed");
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] resultMD5 = md.digest(output.toByteArray());
            if (!Arrays.equals(expectedMD5, resultMD5)) {
                throw new IllegalStateException("Patch application failed: file checksum mismatch, patch may be corrupted");
            }
            if (output.size() == originalSrcSize) return output;
            Logger.getGlobal().warning("Warning: Size mismatch after applying patch, expected " + originalSrcSize + ", actual " + output.size());
            return output;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Failed to calculate MD5 checksum", e);
        }
    }

    private static byte[] readAllBytes(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }
}

