/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.utils;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Reflect {
    public static void enforceType(@NotNull Class<?> field, @NotNull Class<?> value) {
        if (!field.isAssignableFrom(value)) {
            throw new IllegalArgumentException(String.format("Field type mismatch: expected %s, actual %s", field.getName(), value.getName()));
        }
    }

    public static void setNotNullStaticField(@NotNull Class<?> targetClass, @NotNull String fieldName, @NotNull Object value) throws NoSuchFieldException, IllegalAccessException {
        Field field = targetClass.getDeclaredField(fieldName);
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("Field " + fieldName + " is not static.");
        }
        Reflect.enforceType(field.getType(), value.getClass());
        field.setAccessible(true);
        if (field.get(null) != null) {
            return;
        }
        field.set(null, value);
    }

    public static void setNotNullStaticFieldL(@NotNull Class<?> targetClass, @NotNull String fieldName, @NotNull Object value) throws NoSuchFieldException, IllegalAccessException {
        MethodHandles.Lookup lookup = Reflect.getLookup(targetClass);
        Reflect.setNotNullStaticFieldL(lookup, targetClass, fieldName, value);
    }

    public static void setNotNullStaticFieldL(@NotNull MethodHandles.Lookup lookup, @NotNull Class<?> targetClass, @NotNull String fieldName, @NotNull Object value) throws NoSuchFieldException, IllegalAccessException {
        VarHandle field = lookup.findStaticVarHandle(targetClass, fieldName, value.getClass());
        if (field.get() != null) {
            return;
        }
        field.set(value);
    }

    public static void setStaticField(@NotNull Class<?> targetClass, @NotNull String fieldName, @NotNull Object value) throws NoSuchFieldException, IllegalAccessException {
        Field field = targetClass.getDeclaredField(fieldName);
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("Field " + fieldName + " is not static.");
        }
        Reflect.enforceType(field.getType(), value.getClass());
        field.setAccessible(true);
        field.set(null, value);
    }

    public static void setStaticFieldL(@NotNull Class<?> targetClass, @NotNull String fieldName, @NotNull Object value) throws NoSuchFieldException, IllegalAccessException {
        MethodHandles.Lookup lookup = Reflect.getLookup(targetClass);
        Reflect.setStaticFieldL(lookup, targetClass, fieldName, value);
    }

    public static void setStaticFieldL(@NotNull MethodHandles.Lookup lookup, @NotNull Class<?> targetClass, @NotNull String fieldName, @NotNull Object value) throws NoSuchFieldException, IllegalAccessException {
        VarHandle field = lookup.findStaticVarHandle(targetClass, fieldName, value.getClass());
        field.set(value);
    }

    public static void setFieldL(@NotNull Object targetObject, @NotNull String fieldName, @NotNull Object value) throws NoSuchFieldException, IllegalAccessException {
        MethodHandles.Lookup lookup = Reflect.getLookup(targetObject.getClass());
        Reflect.setFieldL(lookup, targetObject, fieldName, value);
    }

    public static void setFieldL(@NotNull MethodHandles.Lookup lookup, @NotNull Object targetObject, @NotNull String fieldName, @NotNull Object value) throws NoSuchFieldException, IllegalAccessException {
        VarHandle field = lookup.findVarHandle(targetObject.getClass(), fieldName, value.getClass());
        field.set(targetObject, value);
    }

    public static void setField(@NotNull Object targetObject, @NotNull String fieldName, @NotNull Object value) throws NoSuchFieldException, IllegalAccessException {
        Field field = targetObject.getClass().getDeclaredField(fieldName);
        Reflect.enforceType(field.getType(), value.getClass());
        field.setAccessible(true);
        field.set(targetObject, value);
    }

    public static Object getStaticField(@NotNull Class<?> targetClass, @NotNull String fieldName) throws IllegalAccessException, NoSuchFieldException {
        Field field = targetClass.getDeclaredField(fieldName);
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("Field " + fieldName + " is not static.");
        }
        field.setAccessible(true);
        return field.get(null);
    }

    public static Object getField(@NotNull Object target, @NotNull String fieldName, @NotNull Object arg) throws NoSuchFieldException, IllegalAccessException {
        Field field = target.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(arg);
    }

    public static Object getField(@NotNull Object targetObject, @NotNull String fieldName, @NotNull Class<?> fieldType, @NotNull Object arg) throws NoSuchFieldException, IllegalAccessException {
        MethodHandles.Lookup lookup = Reflect.getLookup(targetObject.getClass());
        return Reflect.getField(lookup, targetObject, fieldName, fieldType, arg);
    }

    public static Object getField(@NotNull MethodHandles.Lookup lookup, @NotNull Object targetObject, @NotNull String fieldName, @NotNull Class<?> fieldType, @NotNull Object arg) throws NoSuchFieldException, IllegalAccessException {
        VarHandle field = lookup.findVarHandle(targetObject.getClass(), fieldName, fieldType);
        return field.get(arg);
    }

    public static Object getStaticField(@NotNull Class<?> targetClass, @NotNull String fieldName, @NotNull Class<?> fieldType) throws NoSuchFieldException, IllegalAccessException {
        MethodHandles.Lookup lookup = Reflect.getLookup(targetClass);
        return Reflect.getStaticField(lookup, targetClass, fieldName, fieldType);
    }

    public static Object getStaticField(@NotNull MethodHandles.Lookup lookup, @NotNull Class<?> targetClass, @NotNull String fieldName, @NotNull Class<?> fieldType) throws NoSuchFieldException, IllegalAccessException {
        VarHandle field = lookup.findStaticVarHandle(targetClass, fieldName, fieldType);
        return field.get();
    }

    public static MethodHandles.Lookup getLookup(@NotNull Class<?> targetClass) throws IllegalAccessException {
        MethodHandles.Lookup lookup1 = MethodHandles.lookup();
        return MethodHandles.privateLookupIn(targetClass, lookup1);
    }

    public static boolean hasClass(@NotNull String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Nullable
    public static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

