/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.utils.compress;

import com.aayushatharva.brotli4j.decoder.BrotliInputStream;
import com.aayushatharva.brotli4j.encoder.BrotliOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import one.tranic.t.utils.Reflect;
import one.tranic.t.utils.compress.ICompress;

public class BrotliCompress
implements ICompress {
    private static final ICompress INSTANCE = new BrotliCompress();
    private final boolean hasDependency = Reflect.hasClass("com.aayushatharva.brotli4j.decoder.BrotliInputStream");

    private BrotliCompress() {
    }

    public static ICompress getInstance() {
        return INSTANCE;
    }

    protected void checkDependencyPresent(String operation) throws IOException {
        if (!this.hasDependency) {
            throw new IOException(operation + " requires the 'com.aayushatharva.brotli4j:brotli4j' library to be present on the classpath");
        }
    }

    @Override
    public InputStream createDecompressStream(InputStream is) throws IOException {
        this.checkDependencyPresent("BROTLI decompression");
        return new BrotliInputStream(is);
    }

    @Override
    public OutputStream createCompressStream(OutputStream os) throws IOException {
        this.checkDependencyPresent("BROTLI compression");
        return new BrotliOutputStream(os);
    }

    @Override
    public String getFileExtension() {
        return ".zst";
    }
}

