/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.utils.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public interface ICompress {
    public static final int BUFFER_SIZE = 1024;

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
    }

    default public void decompress(InputStream is, OutputStream os) throws IOException {
        try (InputStream decompressStream = this.createDecompressStream(is);){
            ICompress.copyStream(decompressStream, os);
        }
    }

    default public void compress(InputStream is, OutputStream os) throws IOException {
        try (OutputStream compressStream = this.createCompressStream(os);){
            ICompress.copyStream(is, compressStream);
        }
    }

    public InputStream createDecompressStream(InputStream var1) throws IOException;

    public OutputStream createCompressStream(OutputStream var1) throws IOException;

    public String getFileExtension();
}

