/*
 * Decompiled with CFR 0.152.
 */
package one.tranic.t.utils.compress;

import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import one.tranic.t.utils.Reflect;
import one.tranic.t.utils.compress.ICompress;

public class ZstdCompress
implements ICompress {
    private static final ICompress INSTANCE = new ZstdCompress();
    private final boolean hasDependency = Reflect.hasClass("com.github.luben.zstd.ZstdDecompressCtx");

    private ZstdCompress() {
    }

    public static ICompress getInstance() {
        return INSTANCE;
    }

    protected void checkDependencyPresent(String operation) throws IOException {
        if (!this.hasDependency) {
            throw new IOException(operation + " requires the 'com.github.luben:zstd-jni' library to be present on the classpath");
        }
    }

    @Override
    public InputStream createDecompressStream(InputStream is) throws IOException {
        this.checkDependencyPresent("ZSTD decompression");
        return new ZstdInputStream(is);
    }

    @Override
    public OutputStream createCompressStream(OutputStream os) throws IOException {
        this.checkDependencyPresent("ZSTD compression");
        return new ZstdOutputStream(os);
    }

    @Override
    public String getFileExtension() {
        return ".zst";
    }
}

